/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorResource
extends J2EEResourceBase
implements Serializable {
    private static Logger _logger = null;
    public static final String CONNECTOR_OBJECT_FACTORY = "com.sun.enterprise.naming.factory.ConnectorObjectFactory";
    private String dbuser_ = "";
    private String dbpassword_ = "";
    private String connectorname_;
    private String appname_ = "";
    private String connectionFactoryClass_;

    public ConnectorResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        ConnectorResource clone = new ConnectorResource(name);
        clone.setDbuser(this.getDbuser());
        clone.setDbpassword(this.getDbpassword());
        clone.setConnectorName(this.getConnectorName());
        clone.setApplicationName(this.getApplicationName());
        clone.setConnectionFactoryClass(this.getConnectionFactoryClass());
        return clone;
    }

    public int getType() {
        return 6;
    }

    public String getApplicationName() {
        return this.appname_;
    }

    public void setApplicationName(String appname) {
        this.appname_ = appname == null ? "" : appname;
    }

    public String getConnectorName() {
        return this.connectorname_;
    }

    public void setConnectorName(String connectorname) {
        this.connectorname_ = connectorname;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass_;
    }

    public void setConnectionFactoryClass(String cfclass) {
        this.connectionFactoryClass_ = cfclass;
    }

    public String getDbuser() {
        return this.dbuser_;
    }

    public void setDbuser(String dbuser) {
        this.dbuser_ = dbuser == null ? "" : dbuser;
    }

    public String getDbpassword() {
        return this.dbpassword_;
    }

    public void setDbpassword(String dbpassword) {
        this.dbpassword_ = dbpassword == null ? "" : dbpassword;
    }

    public Reference createConnectionFactoryReference() {
        Reference ref = new Reference(this.getConnectionFactoryClass(), new StringRefAddr("jndiName", this.getName()), CONNECTOR_OBJECT_FACTORY, null);
        return ref;
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ClassLoader jcl) throws PoolingException {
        try {
            if (jcl == null) {
                jcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            ResourceInstaller ri = Switch.getSwitch().getResourceInstaller();
            ConnectorDescriptor desc = ri.getDescriptorByConnectorName(this.getApplicationName(), this.getConnectorName());
            String jndiName = this.getName();
            String mcfClass = desc.getManagedConnectionFactoryImpl();
            String appName = this.getApplicationName();
            _logger.log(Level.FINE, "ClassLoader: " + jcl.getClass());
            _logger.log(Level.FINE, "ClassLoader: " + jcl.getParent().getClass());
            _logger.log(Level.FINE, "ClassLoader: " + jcl.getParent().getParent().getClass());
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)Class.forName(mcfClass, true, jcl).newInstance();
            AccessController.doPrivileged(new SetMethodAction(mcf, desc));
            return mcf;
        }
        catch (PrivilegedActionException ex) {
            Exception nested = ex.getException();
            _logger.log(Level.SEVERE, "enterprise.privilegedaction_exception", nested.toString());
            Log.err.flush();
            throw new PoolingException(nested.toString(), nested);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise.managedconnfactory_exception", ex.toString());
            Log.err.flush();
            throw new PoolingException(ex.toString(), ex);
        }
    }

    public Object createConnectionFactory() throws PoolingException {
        ManagedConnectionFactory mcf = this.createManagedConnectionFactory(null);
        try {
            Object cf = mcf.createConnectionFactory((ConnectionManager)new ConnectionManagerImpl(this.getName()));
            return cf;
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "enterprise.resource_exception", ex.toString());
            Log.err.flush();
            throw new PoolingException(ex.toString(), (Exception)((Object)ex));
        }
    }

    public String toString() {
        return "< Connector Resource : " + this.getName() + " , " + this.getApplicationName() + " , " + this.getConnectorName() + " , " + this.getDbuser() + " , " + this.getDbpassword() + " >";
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
    }

    class SetMethodAction
    implements PrivilegedExceptionAction {
        ManagedConnectionFactory mcf;
        ConnectorDescriptor desc;

        SetMethodAction(ManagedConnectionFactory mcf, ConnectorDescriptor desc) {
            this.mcf = mcf;
            this.desc = desc;
        }

        public Object run() throws Exception {
            for (EnvironmentProperty envProp : this.desc.getConfigProperties()) {
                String propName = envProp.getName();
                String propType = envProp.getType();
                String propValue = (String)ConnectorResource.this.getProperty(propName).getValue();
                EnvironmentProperty newProp = new EnvironmentProperty(propName, propValue, "", propType);
                String setMeth = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                Method meth = this.mcf.getClass().getMethod(setMeth, newProp.getValueType());
                meth.invoke((Object)this.mcf, newProp.getValueObject());
            }
            return null;
        }
    }
}

