/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class ResourceManagerImpl
implements ResourceManager {
    static Logger _logger = null;

    public Transaction getTransaction() throws PoolingException {
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        if (inv == null) {
            try {
                return Switch.getSwitch().getTransactionManager().getTransaction();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return inv.getTransaction();
    }

    public Object getComponent() {
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        return inv.getInstance();
    }

    public void enlistResource(ResourceHandle h) throws PoolingException {
        this.registerResource(h);
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        block9: {
            try {
                Transaction tran = null;
                J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
                if (!handle.isTransactional()) break block9;
                InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
                ComponentInvocation inv = invmgr.getCurrentInvocation();
                if (inv == null) {
                    try {
                        tran = tm.getTransaction();
                    }
                    catch (Exception e) {
                        tran = null;
                        _logger.log(Level.INFO, e.getMessage());
                    }
                } else {
                    tran = inv.getTransaction();
                    tm.registerComponentResource(handle);
                }
                if (tran == null) break block9;
                try {
                    tm.enlistResource(tran, handle);
                }
                catch (Exception ex) {
                    _logger.fine("Exception whle trying to enlist resource " + ex.getMessage());
                    if (inv != null) {
                        _logger.fine("Attempting to unregister component resource");
                        tm.unregisterComponentResource(handle);
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "poolmgr.component_register_exception", ex);
                throw new PoolingException(ex.toString(), ex);
            }
        }
    }

    protected void enlist(J2EETransactionManager tm, Transaction tran, ResourceHandle h) throws PoolingException {
        try {
            tm.enlistResource(tran, h);
        }
        catch (Exception e) {
            PoolingException pe = new PoolingException(e.getMessage());
            pe.initCause(e);
            throw pe;
        }
    }

    public void rollBackTransaction() {
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        Transaction tran = null;
        try {
            ComponentInvocation inv = invmgr.getCurrentInvocation();
            if (inv == null) {
                try {
                    tran = tm.getTransaction();
                }
                catch (Exception e) {
                    tran = null;
                    _logger.log(Level.INFO, e.getMessage());
                }
            } else {
                tran = inv.getTransaction();
            }
            if (tran != null) {
                tran.setRollbackOnly();
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    public void delistResource(ResourceHandle resource, int xaresFlag) {
        this.unregisterResource(resource, xaresFlag);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        Transaction tran = null;
        try {
            if (resource.isTransactional()) {
                InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
                ComponentInvocation inv = invmgr.getCurrentInvocation();
                if (inv == null) {
                    try {
                        tran = tm.getTransaction();
                    }
                    catch (Exception e) {
                        tran = null;
                        _logger.log(Level.INFO, e.getMessage());
                    }
                } else {
                    tran = inv.getTransaction();
                    tm.unregisterComponentResource(resource);
                }
                if (tran != null && resource.isEnlisted()) {
                    tm.delistResource(tran, resource, xaresFlag);
                }
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
        }
        catch (InvocationException ex) {
            // empty catch block
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

