/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;

public class PermissionCache {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static Policy policy = Policy.getPolicy();
    private static AllPermission allPermission = new AllPermission();
    private Permissions cache;
    private CodeSource codesource;
    private Permission[] protoPerms;
    private Class[] classes;
    private String name;
    private String pcID;
    private final Integer factoryKey;
    private volatile int epoch;
    private volatile boolean loading;
    private ReadWriteLock rwLock;
    private Lock rLock;
    private Lock wLock;

    public PermissionCache(Integer key, String pcID, CodeSource codesource, Class clazz, String name) {
        this.codesource = codesource == null ? new CodeSource(null, (Certificate[])null) : codesource;
        this.factoryKey = key;
        this.cache = null;
        this.pcID = pcID;
        this.protoPerms = null;
        this.classes = clazz != null ? new Class[]{clazz} : null;
        this.name = name;
        this.epoch = 1;
        this.loading = false;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    public PermissionCache(Integer key, String pcID, CodeSource codesource, Permission[] perms, String name) {
        this.codesource = codesource == null ? new CodeSource(null, (Certificate[])null) : codesource;
        this.factoryKey = key;
        this.cache = null;
        this.pcID = pcID;
        this.protoPerms = perms;
        if (perms != null && perms.length > 0) {
            this.classes = new Class[perms.length];
            for (int i = 0; i < perms.length; ++i) {
                this.classes[i] = perms[i].getClass();
            }
        } else {
            this.classes = null;
        }
        this.name = name;
        this.epoch = 1;
        this.loading = false;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    public Integer getFactoryKey() {
        return this.factoryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCache(Permission p) {
        this.rLock.lock();
        if (this.loading) {
            this.rLock.unlock();
            return false;
        }
        if (this.cache != null) {
            return true;
        }
        this.rLock.unlock();
        this.wLock.lock();
        if (this.loading) {
            this.wLock.unlock();
            return false;
        }
        this.cache = null;
        this.loading = true;
        this.wLock.unlock();
        Permissions nextCache = new Permissions();
        boolean setPc = false;
        String oldpcID = null;
        try {
            oldpcID = PolicyContext.getContextID();
            if (!(this.pcID == oldpcID || this.pcID != null && this.pcID.equals(oldpcID))) {
                setPc = true;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex);
            return false;
        }
        PermissionCollection pc = null;
        try {
            if (setPc) {
                this.setPolicyContextID(this.pcID);
            }
            pc = policy.getPermissions(this.codesource);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (setPc) {
                try {
                    this.setPolicyContextID(oldpcID);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", ex);
                    return false;
                }
            }
        }
        this.resolvePermissions(pc, p);
        Enumeration<Permission> granted = pc.elements();
        while (granted.hasMoreElements()) {
            Permission i = granted.nextElement();
            if (i.equals(allPermission)) {
                nextCache.add(i);
                continue;
            }
            boolean classMatch = true;
            if (this.classes != null) {
                classMatch = false;
                Class<?> iClazz = i.getClass();
                for (int j = 0; j < this.classes.length; ++j) {
                    if (!this.classes[j].equals(iClazz)) continue;
                    classMatch = true;
                    break;
                }
            }
            if (!classMatch) continue;
            if (this.name != null) {
                String name = i.getName();
                if (name == null || !this.name.equals(name)) continue;
                nextCache.add(i);
                continue;
            }
            nextCache.add(i);
        }
        this.wLock.lock();
        this.cache = nextCache;
        this.loading = false;
        this.rLock.lock();
        this.wLock.unlock();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPermission(Permission p, CachedPermissionImpl.Epoch epoch) {
        boolean rvalue = false;
        if (this.loadCache(p)) {
            try {
                if (epoch.epoch != this.epoch) {
                    epoch.granted = this.cache.implies(p);
                    epoch.epoch = this.epoch;
                }
            }
            finally {
                this.rLock.unlock();
            }
            rvalue = epoch.granted;
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPermission(Permission p) {
        boolean rvalue = false;
        if (this.loadCache(p)) {
            try {
                rvalue = this.cache.implies(p);
            }
            finally {
                this.rLock.unlock();
            }
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.wLock.lock();
        try {
            if (this.cache != null) {
                this.cache = null;
                this.epoch = this.epoch + 1 == 0 ? 1 : this.epoch + 1;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    private void setPolicyContextID(final String newID) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                PolicyContext.setContextID((String)newID);
                return null;
            }
        });
    }

    private void resolvePermissions(PermissionCollection pc, Permission p) {
        if (this.protoPerms != null && this.protoPerms.length > 0) {
            for (int i = 0; i < this.protoPerms.length; ++i) {
                pc.implies(this.protoPerms[i]);
            }
        } else {
            pc.implies(p);
        }
    }
}

