/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.event.ApplicationClientEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

class ApplicationClientModuleLoader
extends AbstractLoader {
    private ApplicationClientDescriptor acDescriptor = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private ApplicationLoaderEventNotifier appLoaderEventNotifier;

    ApplicationClientModuleLoader(String modID, ClassLoader parentClassLoader, AppclientModulesManager acModulesManager) {
        super(modID, parentClassLoader, acModulesManager);
        this.setDescriptor();
        try {
            this.application = acModulesManager.getDescriptor(modID, parentClassLoader, false);
            this.appLoaderEventNotifier = ApplicationLoaderEventNotifier.getInstance();
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", ce);
        }
    }

    boolean load(boolean jsr77) {
        this.notifyAppClientEvent(0);
        this.notifyAppClientEvent(1);
        return true;
    }

    boolean unload(boolean jsr77) {
        this.notifyAppClientEvent(2);
        this.configManager.unregisterDescriptor(this.id);
        this.notifyAppClientEvent(3);
        return true;
    }

    void createRootMBean() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().registerAppClient(this.acDescriptor, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void deleteRootMBean() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().unregisterAppClient(this.acDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void createLeafMBeans() throws MBeanException {
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
    }

    void deleteLeafMBeans() throws MBeanException {
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
    }

    private void setDescriptor() {
        this.acDescriptor = this.getApplicationClientDescriptor();
    }

    private ApplicationClientDescriptor getApplicationClientDescriptor() {
        ApplicationClientDescriptor appCD = null;
        try {
            Application app = this.configManager.getDescriptor(this.id, null, false);
            appCD = (ApplicationClientDescriptor)app.getStandaloneBundleDescriptor();
        }
        catch (ConfigException ex) {
            _logger.log(Level.WARNING, "Failed to get the ApplicationClientDescriptor");
        }
        return appCD;
    }

    protected void notifyAppClientEvent(int eventType) {
        ApplicationClientEvent event = new ApplicationClientEvent(eventType, this.getApplication(), this.getClassLoader());
        this.appLoaderEventNotifier.notifyListeners(event);
    }
}

