/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.rmi.Remote;

public class SEIExtendsRemoteCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String s = descriptor.getServiceEndpointInterface();
        if (s == null) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"SEI Class Name Null"}));
            return result;
        }
        Class<?> sei = null;
        try {
            sei = Class.forName(s, false, this.getVerifierContext().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.toString()}));
            return result;
        }
        if (this.getVerifierContext().getSchemaVersion().compareTo("1.1") <= 0) {
            if (!Remote.class.isAssignableFrom(sei)) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "SEI [{0}] does not extend the java.rmi.Remote interface.", new Object[]{s}));
            }
        } else if (Remote.class.isAssignableFrom(sei)) {
            result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "SEI [{0}] is not required to extend the java.rmi.Remote interface.", new Object[]{s}));
        }
        if (result.getStatus() != 1 && result.getStatus() != 2) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Service Enpoint is defined properly"));
        }
        return result;
    }
}

