/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEventListener;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;
import com.sun.enterprise.util.i18n.StringManager;

public class TransactionsRecoveryEventListenerImpl
implements TransactionsRecoveryEventListener {
    private static StringManager sm = StringManager.getManager(TransactionsRecoveryEventListenerImpl.class);

    public void processEvent(TransactionsRecoveryEvent event) throws AdminEventListenerException {
        String currentServer = ApplicationServer.getServerContext().getInstanceName();
        boolean delegated = !currentServer.equals(event.getServerName());
        try {
            JTSMonitorMBean.recover(delegated, event.getLogDir());
        }
        catch (Exception ex) {
            if (ex.getMessage() != null) {
                throw new AdminEventListenerException(ex.getMessage());
            }
            throw new AdminEventListenerException(sm.getString("transaction.unexpected_exception_in_recover-transactions"));
        }
    }
}

