/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.web.EjbWebServiceServletInfo;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.EndpointLifecycleListener;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.TransportType;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public class EjbWebServiceRegistryListener
implements EndpointLifecycleListener {
    private static final EjbWebServiceServletInfo EJB_WEB_SERVICE_SERVLET_INFO = new EjbWebServiceServletInfo();
    private WebContainer webContainer;

    public EjbWebServiceRegistryListener(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void register() {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        wsEngine.addLifecycleListener(this);
        Iterator<Endpoint> endpoints = wsEngine.getEndpoints();
        if (endpoints != null) {
            while (endpoints.hasNext()) {
                this.endpointAdded(endpoints.next());
            }
        }
    }

    public void unregister() {
        WebServiceEngineImpl.getInstance().removeLifecycleListener(this);
    }

    public void endpointAdded(Endpoint endpoint) {
        Application app;
        BundleDescriptor bd;
        if (!TransportType.HTTP.equals((Object)endpoint.getTransport())) {
            return;
        }
        if (!EndpointType.EJB_ENDPOINT.equals((Object)endpoint.getEndpointType())) {
            return;
        }
        URL epURL = null;
        try {
            epURL = new URL(endpoint.getEndpointSelector());
        }
        catch (MalformedURLException me) {
            throw new IllegalArgumentException(me.toString());
        }
        String epURI = epURL.getPath();
        String epCtxRoot = null;
        String epPath = null;
        int index = epURI.indexOf(47, 1);
        if (index < 0) {
            epCtxRoot = epURI;
            epPath = "";
        } else {
            epCtxRoot = epURI.substring(0, index);
            epPath = epURI.substring(index);
        }
        String epSubtree = epPath + "/__container$publishing$subctx/";
        String epAppName = null;
        WebServiceEndpoint wse = endpoint.getDescriptor();
        if (wse != null && (bd = wse.getBundleDescriptor()) != null && (app = bd.getApplication()) != null) {
            epAppName = app.getRegistrationName();
        }
        this.webContainer.registerAdHocPathAndSubtree(epPath, epSubtree, epCtxRoot, epAppName, EJB_WEB_SERVICE_SERVLET_INFO);
    }

    public void endpointRemoved(Endpoint endpoint) {
        if (!TransportType.HTTP.equals((Object)endpoint.getTransport())) {
            return;
        }
        if (!EndpointType.EJB_ENDPOINT.equals((Object)endpoint.getEndpointType())) {
            return;
        }
        URL epURL = null;
        try {
            epURL = new URL(endpoint.getEndpointSelector());
        }
        catch (MalformedURLException me) {
            throw new IllegalArgumentException(me.toString());
        }
        String epURI = epURL.getPath();
        String epCtxRoot = null;
        String epPath = null;
        int index = epURI.indexOf(47, 1);
        if (index < 0) {
            epCtxRoot = epURI;
            epPath = "";
        } else {
            epCtxRoot = epURI.substring(0, index);
            epPath = epURI.substring(index);
        }
        String epSubtree = epPath + "/__container$publishing$subctx/";
        this.webContainer.unregisterAdHocPathAndSubtree(epPath, epSubtree, epCtxRoot);
    }
}

