/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.handlers;

import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.algorithms.ContentLengthAlgorithm;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.tomcat.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentLengthHandler
implements Handler<Request> {
    private SocketChannel socketChannel;
    protected FileCache fileCache;
    private ContentLengthAlgorithm algorithm;

    public ContentLengthHandler(ContentLengthAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.fileCache = FileCacheFactory.getFactory(algorithm.getPort()).getFileCache();
    }

    public void attachChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public int handle(Request request, int handlerCode) throws IOException {
        if (this.socketChannel == null || !FileCacheFactory.isEnabled()) {
            return 0;
        }
        if (this.fileCache == null && handlerCode != 1) {
            return 0;
        }
        if (handlerCode == 1) {
            CoyoteRequest cr = (CoyoteRequest)request.getNote(1);
            if (cr != null && cr.getWrapper() != null) {
                String mappedServlet = cr.getWrapper().getName();
                if (!mappedServlet.equals("default")) {
                    return 0;
                }
                if (cr.getContext().findConstraints().length == 0 && cr.getContext().findFilterDefs().length == 0) {
                    if (!this.fileCache.isEnabled()) {
                        return 0;
                    }
                    String docroot = cr.getContextPath().equals("") ? cr.getContext().getDocBase() : SelectorThread.getWebAppRootPath();
                    String requestURI = cr.getRequestURI();
                    Response response = cr.getCoyoteRequest().getResponse();
                    MimeHeaders headers = response.getMimeHeaders();
                    boolean xPoweredBy = ((CoyoteConnector)cr.getConnector()).isXpoweredBy();
                    this.fileCache.add(mappedServlet, docroot, requestURI, headers, xPoweredBy);
                }
            }
        } else if (handlerCode == 2 && this.algorithm.startReq != -1 && this.fileCache.sendCache(this.algorithm.ascbuf, this.algorithm.startReq, this.algorithm.lengthReq, this.socketChannel, true)) {
            return 1;
        }
        return 0;
    }
}

