/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.BaseAttributeFilter;
import com.sun.org.apache.commons.modeler.BaseNotificationBroadcaster;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.Registry;
import com.sun.org.apache.commons.modeler.modules.ModelerSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class BaseModelMBean
implements ModelMBean,
MBeanRegistration {
    private static Log log = LogFactory.getLog(BaseModelMBean.class);
    protected BaseNotificationBroadcaster attributeBroadcaster = null;
    protected Registry registry = null;
    protected BaseNotificationBroadcaster generalBroadcaster = null;
    protected ObjectName oname = null;
    protected ModelMBeanInfo info = null;
    protected Object resource = null;
    protected String resourceType = null;
    protected ModelerSource source = null;
    protected HashMap attributes = new HashMap();
    static final Object[] NO_ARGS_PARAM = new Object[0];
    static final Class[] NO_ARGS_PARAM_SIG = new Class[0];
    private Hashtable getAttMap = new Hashtable();
    private Hashtable setAttMap = new Hashtable();
    private Hashtable invokeAttMap = new Hashtable();

    public BaseModelMBean() throws MBeanException, RuntimeOperationsException {
        if (log.isDebugEnabled()) {
            log.debug("default constructor");
        }
        this.setModelMBeanInfo(this.createDefaultModelMBeanInfo());
    }

    public BaseModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(info);
        if (log.isDebugEnabled()) {
            log.debug("ModelMBeanInfo constructor");
        }
    }

    public BaseModelMBean(String type) throws MBeanException, RuntimeOperationsException {
        try {
            this.setModeledType(type);
        }
        catch (Throwable ex) {
            log.error("Error creating mbean ", ex);
        }
    }

    public BaseModelMBean(String type, ModelerSource source) throws MBeanException, RuntimeOperationsException {
        try {
            this.setModeledType(type);
        }
        catch (Throwable ex) {
            log.error("Error creating mbean ", ex);
        }
        this.source = source;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).getAttribute(name);
        }
        Method m = (Method)this.getAttMap.get(name);
        if (m == null) {
            ModelMBeanAttributeInfo attrInfo = this.info.getAttribute(name);
            if (attrInfo == null) {
                throw new AttributeNotFoundException(" Cannot find attribute " + name);
            }
            Descriptor attrDesc = attrInfo.getDescriptor();
            if (attrDesc == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + name + " descriptor");
            }
            String getMethod = (String)attrDesc.getFieldValue("getMethod");
            if (getMethod == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + name + " get method name");
            }
            Object object = null;
            NoSuchMethodException exception = null;
            try {
                object = this;
                m = object.getClass().getMethod(getMethod, NO_ARGS_PARAM_SIG);
            }
            catch (NoSuchMethodException e) {
                exception = e;
            }
            if (m == null && this.resource != null) {
                try {
                    object = this.resource;
                    m = object.getClass().getMethod(getMethod, NO_ARGS_PARAM_SIG);
                    exception = null;
                }
                catch (NoSuchMethodException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw new ReflectionException(exception, "Cannot find getter method " + getMethod);
            }
            this.getAttMap.put(name, m);
        }
        Object result = null;
        try {
            Class<?> declaring = m.getDeclaringClass();
            result = declaring.isAssignableFrom(this.getClass()) ? m.invoke((Object)this, NO_ARGS_PARAM) : m.invoke(this.resource, NO_ARGS_PARAM);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, "Exception invoking method " + name);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error invoking method " + name);
            }
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        return result;
    }

    public AttributeList getAttributes(String[] names) {
        if (names == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names list is null"), "Attribute names list is null");
        }
        AttributeList response = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                response.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return response;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            return null;
        }
        return (MBeanInfo)this.info.clone();
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method method;
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).invoke(name, params, signature);
        }
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name is null"), "Method name is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoke " + name);
        }
        if ((method = (Method)this.invokeAttMap.get(name)) == null) {
            if (params == null) {
                params = new Object[]{};
            }
            if (signature == null) {
                signature = new String[]{};
            }
            if (params.length != signature.length) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Inconsistent arguments and signature"), "Inconsistent arguments and signature");
            }
            ModelMBeanOperationInfo opInfo = this.info.getOperation(name);
            if (opInfo == null) {
                throw new MBeanException(new ServiceNotFoundException("Cannot find operation " + name), "Cannot find operation " + name);
            }
            Class[] types = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                types[i] = this.getAttributeClass(signature[i]);
            }
            Object object = null;
            NoSuchMethodException exception = null;
            try {
                object = this;
                method = object.getClass().getMethod(name, types);
            }
            catch (NoSuchMethodException e) {
                exception = e;
            }
            try {
                if (method == null && this.resource != null) {
                    object = this.resource;
                    method = object.getClass().getMethod(name, types);
                }
            }
            catch (NoSuchMethodException e) {
                exception = e;
            }
            if (method == null) {
                throw new ReflectionException(exception, "Cannot find method " + name + " with this signature");
            }
            this.invokeAttMap.put(name, method);
        }
        Object result = null;
        try {
            result = method.getDeclaringClass().isAssignableFrom(this.getClass()) ? method.invoke((Object)this, params) : method.invoke(this.resource, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            log.error("Exception invoking method " + name, t);
            if (t == null) {
                t = e;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, "Exception invoking method " + name);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error invoking method " + name);
            }
            throw new MBeanException((Exception)t, "Exception invoking method " + name);
        }
        catch (Exception e) {
            log.error("Exception invoking method " + name, e);
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        return result;
    }

    private Class getAttributeClass(String signature) throws ReflectionException {
        if (signature.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (signature.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (signature.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (signature.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (signature.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (signature.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (signature.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (signature.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(signature);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            return Class.forName(signature);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "Cannot find Class for " + signature);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug("Setting attribute " + this + " " + attribute);
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            try {
                ((DynamicMBean)this.resource).setAttribute(attribute);
            }
            catch (InvalidAttributeValueException e) {
                throw new MBeanException(e);
            }
            return;
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute is null"), "Attribute is null");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ModelMBeanAttributeInfo attrInfo = this.info.getAttribute(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name);
        }
        Descriptor attrDesc = attrInfo.getDescriptor();
        if (attrDesc == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + " descriptor");
        }
        try {
            Object oldValue = null;
            if (this.getAttMap.get(name) != null) {
                oldValue = this.getAttribute(name);
            }
            this.sendAttributeChangeNotification(new Attribute(name, oldValue), attribute);
        }
        catch (Exception ex) {
            log.error("Error sending notification " + name, ex);
        }
        Method m = (Method)this.setAttMap.get(name);
        if (m == null) {
            String setMethod = (String)attrDesc.getFieldValue("setMethod");
            if (setMethod == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + name + " set method name");
            }
            String argType = attrInfo.getType();
            Class[] signature = new Class[]{this.getAttributeClass(argType)};
            Object object = null;
            NoSuchMethodException exception = null;
            try {
                object = this;
                m = object.getClass().getMethod(setMethod, signature);
            }
            catch (NoSuchMethodException e) {
                exception = e;
            }
            if (m == null && this.resource != null) {
                try {
                    object = this.resource;
                    m = object.getClass().getMethod(setMethod, signature);
                    exception = null;
                }
                catch (NoSuchMethodException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Method not found in resource " + this.resource);
                    }
                    exception = e;
                }
            }
            if (exception != null) {
                throw new ReflectionException(exception, "Cannot find setter method " + setMethod + " " + this.resource);
            }
            this.setAttMap.put(name, m);
        }
        Object result = null;
        try {
            result = m.getDeclaringClass().isAssignableFrom(this.getClass()) ? m.invoke((Object)this, value) : m.invoke(this.resource, value);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, "Exception invoking method " + name);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error invoking method " + name);
            }
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        catch (Exception e) {
            log.error("Exception invoking method " + name, e);
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        this.attributes.put(name, value);
        if (this.source != null) {
            this.source.updateField(this.oname, name, value);
        }
    }

    public String toString() {
        if (this.resource == null) {
            return "BaseModelMbean[" + this.resourceType + "]";
        }
        return this.resource.toString();
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes list is null"), "Attributes list is null");
        }
        AttributeList response = new AttributeList();
        String[] names = new String[attributes.size()];
        int n = 0;
        for (Attribute item : attributes) {
            names[n++] = item.getName();
            try {
                this.setAttribute(item);
            }
            catch (Exception e) {}
        }
        return this.getAttributes(names);
    }

    public Object getManagedResource() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (this.resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        return this.resource;
    }

    public void setManagedResource(Object resource, String type) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        if (!"objectreference".equalsIgnoreCase(type)) {
            throw new InvalidTargetObjectTypeException(type);
        }
        this.resource = resource;
        this.resourceType = resource.getClass().getName();
        try {
            Method m = resource.getClass().getMethod("setModelMBean", ModelMBean.class);
            if (m != null) {
                m.invoke(resource, this);
            }
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            log.error("Can't set model mbean ", t);
        }
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is null"), "ModelMBeanInfo is null");
        }
        if (!this.isModelMBeanInfoValid(info)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is invalid"), "ModelMBeanInfo is invalid");
        }
        this.info = (ModelMBeanInfo)info.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String name, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug("addAttributeNotificationListener " + listener);
        }
        BaseAttributeFilter filter = new BaseAttributeFilter(name);
        this.attributeBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        this.attributeBroadcaster.removeNotificationListener(listener);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws ListenerNotFoundException {
        this.removeAttributeChangeNotificationListener(listener, attributeName);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.attributeBroadcaster == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("AttributeChangeNotification " + notification);
        }
        this.attributeBroadcaster.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException, RuntimeOperationsException {
        String type = null;
        if (newValue.getValue() != null) {
            type = newValue.getValue().getClass().getName();
        } else if (oldValue.getValue() != null) {
            type = oldValue.getValue().getClass().getName();
        } else {
            return;
        }
        AttributeChangeNotification notification = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value has changed", oldValue.getName(), type, oldValue.getValue(), newValue.getValue());
        this.sendAttributeChangeNotification(notification);
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.generalBroadcaster == null) {
            return;
        }
        this.generalBroadcaster.sendNotification(notification);
    }

    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        if (message == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Message is null"), "Message is null");
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("addNotificationListener " + listener);
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.addNotificationListener(listener, filter, handback);
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug("addAttributeNotificationListener " + listener);
        }
        this.attributeBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] current = this.info.getNotifications();
        if (current == null) {
            current = new MBeanNotificationInfo[]{};
        }
        MBeanNotificationInfo[] response = new MBeanNotificationInfo[current.length + 2];
        DescriptorSupport descriptor = null;
        descriptor = new DescriptorSupport("name=GENERIC", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.modelmbean.generic");
        response[0] = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "Text message notification from the managed resource", descriptor);
        descriptor = new DescriptorSupport("name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.attribute.change");
        response[1] = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Observed MBean attribute value has changed", descriptor);
        System.arraycopy(current, 0, response, 2, current.length);
        return response;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void load() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    public void store() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    public void setModeledType(String type) {
        this.initModelInfo(type);
        this.createResource();
    }

    protected void initModelInfo(String type) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("setModeledType " + type);
            }
            log.debug("Set model Info " + type);
            if (type == null) {
                return;
            }
            this.resourceType = type;
            Class<?> c = null;
            try {
                c = Class.forName(type);
            }
            catch (Throwable t) {
                log.debug("Error creating class " + t);
            }
            ManagedBean descriptor = this.getRegistry().findManagedBean(c, type);
            if (descriptor == null) {
                return;
            }
            this.setModelMBeanInfo(descriptor.createMBeanInfo());
        }
        catch (Throwable ex) {
            log.error("TCL: " + Thread.currentThread().getContextClassLoader(), ex);
        }
    }

    protected void createResource() {
        try {
            Class<?> c = null;
            try {
                c = Class.forName(this.resourceType);
                this.resource = c.newInstance();
            }
            catch (Throwable t) {
                log.error("Error creating class " + t);
            }
        }
        catch (Throwable ex) {
            log.error("TCL: " + Thread.currentThread().getContextClassLoader(), ex);
        }
    }

    public String getModelerType() {
        return this.resourceType;
    }

    public String getClassName() {
        return this.getModelerType();
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        return this.registry;
    }

    protected ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    protected boolean isModelMBeanInfoValid(ModelMBeanInfo info) {
        return true;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("preRegister " + this.resource + " " + name);
        }
        this.oname = name;
        if (this.resource instanceof MBeanRegistration) {
            this.oname = ((MBeanRegistration)this.resource).preRegister(server, name);
        }
        return this.oname;
    }

    public void postRegister(Boolean registrationDone) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(registrationDone);
        }
    }

    public void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    public void postDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }
}

