/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcherForward;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

final class ApplicationDispatcher
implements RequestDispatcher {
    private static Log log = LogFactory.getLog(ApplicationDispatcher.class);
    private ServletRequest appRequest = null;
    private ServletResponse appResponse = null;
    private Boolean crossContextFlag = null;
    private Context context = null;
    private int debug = 0;
    private boolean including = false;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private ServletRequest outerRequest = null;
    private ServletResponse outerResponse = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private String origServletPath = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;
    private Wrapper wrapper = null;
    private ServletRequest wrapRequest = null;
    private ServletResponse wrapResponse = null;

    public ApplicationDispatcher(Wrapper wrapper, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.origServletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        this.support = ((StandardWrapper)wrapper).getInstanceSupport();
        if (log.isDebugEnabled()) {
            log.debug("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name);
        }
    }

    public String getInfo() {
        return info;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
                ApplicationDispatcherForward.commit((HttpServletRequest)request, (HttpServletResponse)response, this.context, this.wrapper);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
            ApplicationDispatcherForward.commit((HttpServletRequest)request, (HttpServletResponse)response, this.context, this.wrapper);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            if (log.isDebugEnabled()) {
                log.debug("  Forward on committed response --> ISE");
            }
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        try {
            response.resetBuffer();
        }
        catch (IllegalStateException e) {
            if (log.isDebugEnabled()) {
                log.debug("  Forward resetBuffer() returned ISE: " + e);
            }
            throw e;
        }
        this.setup(request, response, false);
        HttpServletRequest hrequest = null;
        hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = null;
        hresponse = (HttpServletResponse)response;
        if (hrequest == null || hresponse == null) {
            if (log.isDebugEnabled()) {
                log.debug(" Non-HTTP Forward");
            }
            this.processRequest((ServletRequest)hrequest, (ServletResponse)hresponse);
        } else if (this.servletPath == null && this.pathInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug(" Named Dispatcher Forward");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response);
            wrequest.recycle();
            this.unwrapRequest();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(" Path Based Forward");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            String contextPath = this.context.getPath();
            if (hrequest.getAttribute("javax.servlet.forward.request_uri") == null) {
                wrequest.setAttribute("javax.servlet.forward.request_uri", hrequest.getRequestURI());
                wrequest.setAttribute("javax.servlet.forward.context_path", hrequest.getContextPath());
                wrequest.setAttribute("javax.servlet.forward.servlet_path", hrequest.getServletPath());
                wrequest.setAttribute("javax.servlet.forward.path_info", hrequest.getPathInfo());
                wrequest.setAttribute("javax.servlet.forward.query_string", hrequest.getQueryString());
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response);
            wrequest.recycle();
            this.unwrapRequest();
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        Integer disInt = (Integer)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (disInt != null) {
            if (disInt != 1) {
                this.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.origServletPath);
                this.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)new Integer(2));
                this.invoke(this.outerRequest, response);
            } else {
                this.invoke(this.outerRequest, response);
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.setup(request, response, true);
        ServletResponse wresponse = this.wrapResponse();
        if (this.name != null) {
            if (log.isDebugEnabled()) {
                log.debug(" Named Dispatcher Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", new Integer(4));
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.origServletPath);
            this.invoke(this.outerRequest, this.outerResponse);
            wrequest.recycle();
            this.unwrapRequest();
            this.unwrapResponse();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(" Path Based Include");
            }
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest();
            String contextPath = this.context.getPath();
            if (this.requestURI != null) {
                wrequest.setAttribute("javax.servlet.include.request_uri", this.requestURI);
            }
            if (contextPath != null) {
                wrequest.setAttribute("javax.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", new Integer(4));
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.origServletPath);
            this.invoke(this.outerRequest, this.outerResponse);
            wrequest.recycle();
            this.unwrapRequest();
            this.unwrapResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        boolean crossContext = false;
        if (this.crossContextFlag != null && this.crossContextFlag.booleanValue()) {
            crossContext = true;
        }
        if (crossContext) {
            this.context.getManager().lockSession(request);
        }
        try {
            if (crossContext) {
                this.context.getManager().preRequestDispatcherProcess(request, response);
            }
            this.doInvoke(request, response);
            if (crossContext) {
                this.context.getManager().postRequestDispatcherProcess(request, response);
            }
        }
        finally {
            if (crossContext) {
                this.context.getManager().unlockSession(request);
            }
            this.crossContextFlag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ClassLoader contextClassLoader;
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        if (oldCCL != (contextClassLoader = this.context.getLoader().getClassLoader())) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        } else {
            oldCCL = null;
        }
        HttpServletRequest hrequest = null;
        hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = null;
        hresponse = (HttpServletResponse)response;
        Servlet servlet = null;
        IOException ioException = null;
        Throwable servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.log(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            if (hresponse != null) {
                long available = this.wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hresponse.setDateHeader("Retry-After", available);
                }
                hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            }
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), StandardWrapper.getRootCause(e));
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
        ApplicationFilterChain filterChain = factory.createFilterChain(request, this.wrapper, servlet);
        CoyoteRequest origRequest = null;
        try {
            String jspFile = this.wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            this.support.fireInstanceEvent("beforeDispatch", servlet, request, response);
            if (servlet != null) {
                origRequest = this.getCoyoteRequest(request);
                if (origRequest != null) {
                    origRequest.incrementDispatchDepth();
                    if (origRequest.isMaxDispatchDepthReached()) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = new Integer(origRequest.getMaxDispatchDepth());
                        throw new ServletException(sm.getString("applicationDispatcher.maxDispatchDepthReached", objectArray));
                    }
                }
                if (filterChain != null) {
                    filterChain.doFilter(request, response);
                } else {
                    ApplicationFilterChain.servletService(request, response, servlet, this.support);
                }
            }
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
        }
        catch (ClientAbortException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            ioException = e;
        }
        catch (IOException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            ioException = e;
        }
        catch (UnavailableException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof ClientAbortException)) {
                this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            request.removeAttribute("org.apache.catalina.jsp_file");
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            runtimeException = e;
        }
        finally {
            if (origRequest != null) {
                origRequest.decrementDispatchDepth();
            }
        }
        try {
            if (filterChain != null) {
                filterChain.release();
            }
        }
        catch (Throwable e) {
            log.error(sm.getString("standardWrapper.releaseFilters", this.wrapper.getName()), e);
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        if (oldCCL != null) {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "] " + message, throwable);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private void setup(ServletRequest request, ServletResponse response, boolean including) {
        this.appRequest = request;
        this.appResponse = response;
        this.outerRequest = request;
        this.outerResponse = response;
        this.including = including;
    }

    private void unwrapRequest() {
        if (this.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = this.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == this.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    this.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse() {
        if (this.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = this.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == this.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    this.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest() {
        ServletRequest previous = null;
        ServletRequest current = this.outerRequest;
        while (!(current == null || "org.apache.catalina.servlets.InvokerHttpRequest".equals(current.getClass().getName()) || !(current instanceof ServletRequestWrapper) || current instanceof ApplicationHttpRequest || current instanceof ApplicationRequest || current instanceof Request)) {
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        Object wrapper = null;
        if (current instanceof ApplicationHttpRequest || current instanceof HttpRequest || current instanceof HttpServletRequest) {
            HttpServletRequest hcurrent = (HttpServletRequest)current;
            boolean crossContext = !this.context.getPath().equals(hcurrent.getContextPath());
            this.crossContextFlag = new Boolean(crossContext);
            wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext);
        } else {
            wrapper = new ApplicationRequest(current);
        }
        if (previous == null) {
            this.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest((ServletRequest)wrapper);
        }
        this.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse() {
        ServletResponse previous = null;
        ServletResponse current = this.outerResponse;
        while (current != null && current instanceof ServletResponseWrapper && !(current instanceof ApplicationHttpResponse) && !(current instanceof ApplicationResponse) && !(current instanceof Response)) {
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        Object wrapper = null;
        wrapper = current instanceof ApplicationHttpResponse || current instanceof HttpResponse || current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, this.including) : new ApplicationResponse(current, this.including);
        if (previous == null) {
            this.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse((ServletResponse)wrapper);
        }
        this.wrapResponse = wrapper;
        return wrapper;
    }

    private CoyoteRequest getCoyoteRequest(ServletRequest request) {
        CoyoteRequest coyoteRequest = null;
        ServletRequest current = request;
        while (current != null) {
            if (current instanceof CoyoteRequestFacade) {
                coyoteRequest = ((CoyoteRequestFacade)current).getUnwrappedCoyoteRequest();
                break;
            }
            if (!(current instanceof ServletRequestWrapper)) break;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        return coyoteRequest;
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws Exception {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }
}

