/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.rm.RMConstants;
import com.sun.xml.ws.rm.RMException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class SequenceConfig
extends SequenceSettings {
    public SequenceConfig() {
        if (this.constants == null) {
            this.constants = RMConstants.getRMConstants(AddressingVersion.W3C);
        }
        this.acksTo = this.constants.getAnonymousURI().toString();
        this.ordered = false;
        this.allowDuplicates = false;
        this.inactivityTimeout = 600000L;
        this.flowControl = false;
        this.bufferSize = 32;
        this.soapVersion = SOAPVersion.SOAP_12;
        this.ackRequestInterval = 0L;
        this.resendInterval = 0L;
        this.closeTimeout = 0L;
    }

    public SequenceConfig(WSDLPort port, WSBinding wsbinding) {
        this();
        if (port != null) {
            WSDLBoundPortType binding = port.getBinding();
            WSDLModel model = binding.getOwner();
            PolicyMap policyMap = model.getExtension(WSDLPolicyMapWrapper.class).getPolicyMap();
            this.constants = RMConstants.getRMConstants(wsbinding.getAddressingVersion());
            try {
                this.init(port, policyMap);
            }
            catch (RMException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
    }

    public SequenceConfig(SequenceSettings toCopy) {
        this.ackRequestInterval = toCopy.ackRequestInterval;
        this.acksTo = toCopy.acksTo;
        this.allowDuplicates = toCopy.allowDuplicates;
        this.bufferSize = toCopy.bufferSize;
        this.closeTimeout = toCopy.closeTimeout;
        this.constants = toCopy.constants;
        this.flowControl = toCopy.flowControl;
        this.inactivityTimeout = toCopy.inactivityTimeout;
        this.ordered = toCopy.ordered;
        this.resendInterval = toCopy.resendInterval;
        this.soapVersion = toCopy.soapVersion;
    }

    public String getAcksTo() {
        return this.acksTo;
    }

    public void setAcksTo(String acksTo) {
        this.acksTo = acksTo;
    }

    public boolean getOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(long inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long timeout) {
        this.closeTimeout = timeout;
    }

    public SOAPVersion getSoapVersion() {
        if (this.soapVersion != null) {
            return this.soapVersion;
        }
        return SOAPVersion.SOAP_12;
    }

    public void setSoapVersion(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(boolean use) {
        this.flowControl = use;
    }

    public long getResendInterval() {
        return this.resendInterval;
    }

    public void setResendInterval(long interval) {
        this.resendInterval = interval;
    }

    public long getAckRequestInterval() {
        return this.ackRequestInterval;
    }

    public void setAckRequestInterval(long interval) {
        this.ackRequestInterval = interval;
    }

    public void init(WSDLPort port, PolicyMap policyMap) throws RMException {
        try {
            if (policyMap != null) {
                PolicyMapKey endpointScopeKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
                if (endpointScopeKey != null) {
                    Iterator<AssertionSet> i$;
                    AssertionSet policyAssertionSet = null;
                    Policy policy = policyMap.getEndpointEffectivePolicy(endpointScopeKey);
                    if (policy != null && (i$ = policy.iterator()).hasNext()) {
                        AssertionSet set;
                        policyAssertionSet = set = i$.next();
                    }
                    if (policyAssertionSet != null) {
                        PolicyAssertion rmAssertion = null;
                        PolicyAssertion flowAssertion = null;
                        for (PolicyAssertion assertion : policyAssertionSet) {
                            String num;
                            QName qname = assertion.getName();
                            if (qname.equals(this.constants.getRMAssertionQName())) {
                                rmAssertion = assertion;
                                continue;
                            }
                            if (qname.equals(this.constants.getRMFlowControlQName())) {
                                flowAssertion = assertion;
                                continue;
                            }
                            if (qname.equals(this.constants.getOrderedQName())) {
                                this.ordered = true;
                                continue;
                            }
                            if (qname.equals(this.constants.getAllowDuplicatesQName())) {
                                this.allowDuplicates = true;
                                continue;
                            }
                            if (qname.equals(this.constants.getAckRequestIntervalQName())) {
                                num = assertion.getAttributeValue(new QName("", "Milliseconds"));
                                if (num == null) continue;
                                this.ackRequestInterval = Long.parseLong(num);
                                continue;
                            }
                            if (qname.equals(this.constants.getResendIntervalQName())) {
                                num = assertion.getAttributeValue(new QName("", "Milliseconds"));
                                if (num == null) continue;
                                this.resendInterval = Long.parseLong(num);
                                continue;
                            }
                            if (!qname.equals(this.constants.getCloseTimeoutQName()) || (num = assertion.getAttributeValue(new QName("", "Milliseconds"))) == null) continue;
                            this.closeTimeout = Long.parseLong(num);
                        }
                        if (rmAssertion != null) {
                            this.handleRMAssertion(rmAssertion);
                        }
                        if (flowAssertion != null) {
                            this.handleFlowAssertion(flowAssertion);
                        }
                    }
                }
            }
        }
        catch (PolicyException e) {
            e.printStackTrace();
        }
    }

    private void handleRMAssertion(PolicyAssertion rmAssertion) {
        Iterator<PolicyAssertion> it = rmAssertion.getNestedAssertionsIterator();
        while (it != null && it.hasNext()) {
            PolicyAssertion assertion = it.next();
            if (assertion.getName().equals(this.constants.getInactivityTimeoutQName())) {
                String num = assertion.getAttributeValue(new QName("", "Milliseconds"));
                if (num == null) continue;
                this.inactivityTimeout = Long.parseLong(num);
                continue;
            }
            if (!assertion.getName().equals(this.constants.getAcknowledgementIntervalQName())) continue;
        }
    }

    private void handleFlowAssertion(PolicyAssertion flowAssertion) {
        this.flowControl = true;
        Iterator<PolicyAssertion> it = flowAssertion.getNestedAssertionsIterator();
        while (it != null && it.hasNext()) {
            PolicyAssertion assertion = it.next();
            if (!assertion.getName().equals(this.constants.getMaxReceiveBufferSizeQName())) continue;
            this.bufferSize = Integer.parseInt(assertion.getValue());
            break;
        }
    }

    public RMConstants getRMConstants() {
        return this.constants;
    }

    public RMConstants getConstants() {
        return this.constants;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }
}

