/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.rm.AcknowledgementListener;
import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.api.rm.client.ClientSequence;
import com.sun.xml.ws.rm.InvalidMessageNumberException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.client.ProtocolMessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.jaxws.util.LoggingHelper;
import com.sun.xml.ws.rm.protocol.AcceptType;
import com.sun.xml.ws.rm.protocol.AcknowledgementHandler;
import com.sun.xml.ws.rm.protocol.CreateSequenceElement;
import com.sun.xml.ws.rm.protocol.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.protocol.Identifier;
import com.sun.xml.ws.rm.protocol.OfferType;
import com.sun.xml.ws.rm.protocol.TerminateSequenceElement;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOutboundSequence
extends OutboundSequence
implements ClientSequence {
    private static final Logger logger = Logger.getLogger(LoggingHelper.getLoggerName(ClientOutboundSequence.class));
    protected int receiveBufferSize;
    protected ProtocolMessageSender protocolMessageSender;
    private SOAPVersion version;
    private boolean secureReliableMessaging;
    private JAXBElement<SecurityTokenReferenceType> str = null;
    private boolean isAnonymous = false;
    private boolean isActive = true;
    private long resendDeadline;
    private long ackRequestDeadline;
    private AcknowledgementListener ackListener;
    private Service service;
    private static boolean sendHeartbeats = true;

    public ClientOutboundSequence(SequenceConfig config) {
        this.config = config;
        this.version = config.getSoapVersion();
        this.ackHandler = new AcknowledgementHandler(config);
        this.rmConstants = config.getRMConstants();
        this.bufferRemaining = config.getBufferSize();
    }

    public SequenceConfig getSequenceConfig() {
        return this.config;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public boolean isSecureReliableMessaging() {
        return this.secureReliableMessaging;
    }

    public int getTransferWindowSize() {
        return this.config.getBufferSize();
    }

    @Override
    public void setAcknowledgementListener(AcknowledgementListener listener) {
        this.ackListener = listener;
    }

    @Override
    public SequenceSettings getSequenceSettings() {
        SequenceConfig settings = this.getSequenceConfig();
        settings.sequenceId = this.getId();
        InboundSequence iseq = this.getInboundSequence();
        settings.companionSequenceId = iseq != null ? iseq.getId() : null;
        return settings;
    }

    public AcknowledgementListener getAcknowledgementListener() {
        return this.ackListener;
    }

    public void setSecureReliableMessaging(boolean secureReliableMessaging) {
        this.secureReliableMessaging = secureReliableMessaging;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void connect(URI destination, URI acksTo, boolean twoWay) throws RMException {
        try {
            CreateSequenceResponseElement csr;
            this.destination = destination;
            this.acksTo = acksTo;
            String anonymous = this.rmConstants.getAnonymousURI().toString();
            String acksToString = acksTo == null ? anonymous : acksTo.toString();
            this.isAnonymous = acksToString.equals(anonymous);
            CreateSequenceElement cs = new CreateSequenceElement();
            W3CEndpointReference endpointReference = null;
            AddressingVersion addressingVersion = this.rmConstants.getAddressingVersion();
            if (addressingVersion == AddressingVersion.W3C) {
                WSEndpointReference epr = AddressingVersion.W3C.anonymousEpr;
                Source s = epr.asSource("AcksTo");
                endpointReference = new W3CEndpointReference(s);
            }
            cs.setAcksTo(endpointReference);
            String incomingID = "uuid:" + UUID.randomUUID();
            if (twoWay) {
                Identifier id = new Identifier();
                id.setValue(incomingID);
                OfferType offer = new OfferType();
                offer.setIdentifier(id);
                cs.setOffer(offer);
            }
            if (this.secureReliableMessaging) {
                JAXBElement<SecurityTokenReferenceType> str = this.getSecurityTokenReference();
                if (str != null) {
                    cs.setSecurityTokenReference((SecurityTokenReferenceType)str.getValue());
                } else {
                    throw new RMException("SecurityTokenReference is null");
                }
            }
            if ((csr = this.protocolMessageSender.sendCreateSequence(cs, destination, acksTo, this.version)) != null) {
                Identifier idOutbound = csr.getIdentifier();
                this.id = idOutbound.getValue();
                AcceptType accept = csr.getAccept();
                if (accept != null) {
                    URI uriAccept = null;
                    this.inboundSequence = new ClientInboundSequence(this, incomingID, uriAccept);
                } else {
                    this.inboundSequence = new ClientInboundSequence(this, incomingID, null);
                }
                this.resetLastActivityTime();
            }
        }
        catch (Exception e) {
            throw new RMException(e);
        }
    }

    public void disconnect() throws RMException {
        this.disconnect(false);
    }

    public void disconnect(boolean keepAlive) throws RMException {
        if (this.inboundSequence == null) {
            throw new IllegalStateException("Not connected.");
        }
        this.isActive = keepAlive;
        this.sendLast();
        this.waitForAcks();
        TerminateSequenceElement ts = new TerminateSequenceElement();
        Identifier idTerminate = new Identifier();
        idTerminate.setValue(this.id);
        ts.setIdentifier(idTerminate);
        this.protocolMessageSender.sendTerminateSequence(ts, this, this.version);
    }

    private void sendLast() throws RMException {
        this.protocolMessageSender.sendLast(this, this.version);
    }

    public void resend(int messageNumber) throws RMException {
        Message mess = this.get(messageNumber);
        mess.resume();
    }

    public synchronized void requestAck() {
        this.ackRequestDeadline = System.currentTimeMillis();
    }

    @Override
    protected synchronized boolean isAckRequested() {
        long time = System.currentTimeMillis();
        if (time > this.ackRequestDeadline) {
            this.ackRequestDeadline = time + this.getAckRequestInterval();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isResendDue() {
        long time = System.currentTimeMillis();
        if (time > this.resendDeadline) {
            this.resendDeadline = time + this.getResendInterval();
            return true;
        }
        return false;
    }

    private long getResendInterval() {
        if (!this.isActive || this.storedMessages > this.getTransferWindowSize() / 2) {
            return 0L;
        }
        return this.config.getResendInterval();
    }

    public boolean isTransferWindowFull() {
        return this.getTransferWindowSize() == this.storedMessages;
    }

    private long getAckRequestInterval() {
        if (!this.isActive || this.storedMessages > this.getTransferWindowSize() / 2 || this.getReceiveBufferSize() > this.config.getBufferSize() / 2) {
            return 0L;
        }
        return this.config.getAckRequestInterval();
    }

    @Override
    public synchronized void acknowledge(int i) throws InvalidMessageNumberException {
        Message mess = this.get(i);
        if (this.isAnonymous() && mess.isTwoWayRequest) {
            return;
        }
        super.acknowledge(i);
        if (this.ackListener != null) {
            this.ackListener.notify(this, i);
        }
        mess.resume();
    }

    public synchronized void acknowledgeResponse(int i) throws InvalidMessageNumberException {
        super.acknowledge(i);
        if (this.ackListener != null) {
            this.ackListener.notify(this, i);
        }
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void registerProtocolMessageSender(ProtocolMessageSender pms) {
        this.protocolMessageSender = pms;
    }

    public JAXBElement<SecurityTokenReferenceType> getSecurityTokenReference() {
        return this.str;
    }

    public void setSecurityTokenReference(JAXBElement<SecurityTokenReferenceType> str) {
        this.str = str;
    }

    public synchronized void doMaintenanceTasks() throws RMException {
        if (this.storedMessages > 0 && this.isResendDue()) {
            int top = this.getNextIndex();
            for (int i = 1; i < top; ++i) {
                Message mess = this.get(i);
                if (mess == null || mess.isComplete()) continue;
                logger.fine("resending " + this.getId() + ":" + i);
                this.resend(i);
            }
        } else if (this.isGettingClose(System.currentTimeMillis() - this.getLastActivityTime(), this.config.getInactivityTimeout())) {
            new AckRequestedSender(this).start();
        }
    }

    private class AckRequestedSender
    extends Thread {
        private ClientOutboundSequence sequence;

        AckRequestedSender(ClientOutboundSequence sequence) {
            this.sequence = sequence;
        }

        public void run() {
            try {
                if (sendHeartbeats) {
                    logger.fine(Messages.HEARTBEAT_MESSAGE_MESSAGE.format(this.sequence.getId(), System.currentTimeMillis()));
                    ClientOutboundSequence.this.protocolMessageSender.sendAckRequested(this.sequence, ClientOutboundSequence.this.version);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, Messages.HEARTBEAT_MESSAGE_EXCEPTION.format(new Object[0]) + " " + this.sequence.getId(), e);
                try {
                    RMSource.getRMSource().removeOutboundSequence(this.sequence);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

