/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundMessageProcessor;
import com.sun.xml.ws.rm.jaxws.runtime.PipeBase;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientSession;
import com.sun.xml.ws.rm.jaxws.runtime.client.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.client.ProtocolMessageReceiver;
import com.sun.xml.ws.rm.jaxws.runtime.client.ProtocolMessageSender;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.jaxws.util.LoggingHelper;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMClientPipe
extends PipeBase<RMSource, ClientOutboundSequence, ClientInboundSequence> {
    public static final Logger logger = Logger.getLogger(LoggingHelper.getLoggerName(RMClientPipe.class));
    public static final LoggingHelper logHelper = new LoggingHelper(logger);
    private WSDLPort port;
    private WSService service;
    private WSBinding binding;
    private SecureConversationInitiator securityPipe;
    private SequenceConfig config;
    private ClientOutboundSequence outboundSequence;
    private ClientInboundSequence inboundSequence;
    private InboundMessageProcessor messageProcessor;
    private boolean secureReliableMessaging;
    private BindingProvider proxy;
    private Boolean isOneWayMessage = false;

    public RMClientPipe(WSDLPort port, WSService service, WSBinding binding, SecureConversationInitiator securityPipe, Pipe nextPipe) {
        super(RMSource.getRMSource(), nextPipe);
        this.port = port;
        this.service = service;
        this.binding = binding;
        this.securityPipe = securityPipe;
        this.config = new SequenceConfig(port, binding);
        this.config.setSoapVersion(binding.getSOAPVersion());
        this.messageProcessor = ((RMSource)this.provider).getInboundMessageProcessor();
        this.secureReliableMessaging = securityPipe != null;
        this.unmarshaller = this.config.getRMConstants().createUnmarshaller();
        this.marshaller = this.config.getRMConstants().createMarshaller();
    }

    private RMClientPipe(RMClientPipe toCopy, PipeCloner cloner) {
        super(RMSource.getRMSource(), null);
        cloner.add(toCopy, this);
        this.nextPipe = cloner.copy(toCopy.nextPipe);
        if (this.securityPipe != null) {
            this.securityPipe = toCopy.securityPipe;
            this.secureReliableMessaging = true;
        } else {
            this.securityPipe = null;
            this.secureReliableMessaging = false;
        }
        this.port = toCopy.port;
        this.service = toCopy.service;
        this.binding = toCopy.binding;
        this.config = toCopy.config;
        this.messageProcessor = ((RMSource)this.provider).getInboundMessageProcessor();
        this.outboundSequence = toCopy.outboundSequence;
        this.inboundSequence = toCopy.inboundSequence;
        this.unmarshaller = this.config.getRMConstants().createUnmarshaller();
        this.marshaller = this.config.getRMConstants().createMarshaller();
    }

    private synchronized void initialize(Packet packet) throws RMException {
        String dest = packet.endpointAddress.toString();
        if (this.outboundSequence != null) {
            if (dest != null && !dest.equals("") && this.outboundSequence.getDestination().toString() != dest) {
                throw new RMException(Messages.UNCHANGEABLE_ENDPOINT_ADDRESS.format(new Object[0]));
            }
        } else {
            URI acksToURI;
            URI destURI;
            if (this.binding.getAddressingVersion() == AddressingVersion.MEMBER) {
                throw new RMException(Messages.UNSUPPORTED_ADDRESSING_VERSION.format(new Object[0]));
            }
            this.proxy = packet.proxy;
            if (dest == null) {
                dest = this.port.getAddress().toString();
            }
            String acksTo = ProtocolMessageReceiver.getAcksTo();
            boolean twoWay = this.checkForTwoWayOperation();
            try {
                destURI = new URI(dest);
            }
            catch (URISyntaxException e) {
                throw new RMException(Messages.INVALID_DEST_URI.format(dest));
            }
            try {
                acksToURI = new URI(acksTo);
            }
            catch (URISyntaxException e) {
                throw new RMException(Messages.INVALID_ACKS_TO_URI.format(acksTo));
            }
            ClientOutboundSequence specifiedOutboundSequence = (ClientOutboundSequence)packet.proxy.getRequestContext().get("com.sun.xml.ws.sequence");
            if (specifiedOutboundSequence != null) {
                this.outboundSequence = specifiedOutboundSequence;
            } else {
                this.outboundSequence = new ClientOutboundSequence(this.config);
                if (this.secureReliableMessaging) {
                    try {
                        JAXBElement str = this.securityPipe.startSecureConversation(packet);
                        this.outboundSequence.setSecurityTokenReference((JAXBElement<SecurityTokenReferenceType>)str);
                        if (str == null) {
                            this.secureReliableMessaging = false;
                        }
                    }
                    catch (Exception e) {
                        this.secureReliableMessaging = false;
                        this.outboundSequence.setSecurityTokenReference(null);
                    }
                }
                this.outboundSequence.setSecureReliableMessaging(this.secureReliableMessaging);
                this.outboundSequence.registerProtocolMessageSender(new ProtocolMessageSender(this.messageProcessor, this.marshaller, this.unmarshaller, this.port, this.binding, this.nextPipe, packet));
                this.outboundSequence.connect(destURI, acksToURI, twoWay);
                this.inboundSequence = (ClientInboundSequence)this.outboundSequence.getInboundSequence();
                ClientSession.setSession(this.proxy, new ClientSession(this.outboundSequence.getId(), this));
                ((RMSource)this.provider).addOutboundSequence(this.outboundSequence);
                String reqUri = packet.getMessage().getPayloadNamespaceURI();
                if (reqUri.equals("http://com.sun/createSequence")) {
                    packet.invocationProperties.put("com.sun.xml.ws.createsequence", this.outboundSequence);
                }
                packet.proxy.getRequestContext().put("com.sun.xml.ws.sequence", this.outboundSequence);
            }
        }
    }

    private Packet trySend(Packet packet, Message message) {
        try {
            packet.expectReply = true;
            com.sun.xml.ws.api.message.Message copy = message.getCopy();
            packet.setMessage(copy);
            return this.nextPipe.process(packet);
        }
        catch (ClientTransportException ee) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, Messages.QUEUE_FOR_RESEND.format(ee.toString()), (Throwable)((Object)ee));
            }
            return null;
        }
        catch (WebServiceException e) {
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof IOException || cause instanceof SocketTimeoutException)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, Messages.QUEUE_FOR_RESEND.format(e.toString()), e);
                }
                return null;
            }
            logger.log(Level.SEVERE, Messages.UNEXPECTED_WRAPPED_EXCEPTION.format(new Object[0]), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, Messages.UNEXPECTED_TRY_SEND_EXCEPTION.format(new Object[0]), e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public Packet doRetryLoop(Packet packet, Message message) throws RMException {
        try {
            while (!message.isComplete()) {
                Packet ret = null;
                this.filter = ((RMSource)this.provider).getProcessingFilter();
                if (this.filter == null || this.filter.handleClientRequestMessage(message)) {
                    this.outboundSequence.resetLastActivityTime();
                    this.isOneWayMessage = packet.getMessage().isOneWay(this.port);
                    ret = this.trySend(packet, message);
                    if (ret != null) {
                        com.sun.xml.ws.api.message.Message mess = ret.getMessage();
                        Message rmMessage = null;
                        if (mess != null) {
                            rmMessage = this.handleInboundMessage(ret);
                        }
                        if (this.filter != null) {
                            this.filter.handleClientResponseMessage(rmMessage);
                        }
                        if (mess != null && mess.isFault()) {
                            logger.log(Level.FINE, Messages.ACKING_FAULTED_MESSAGE.format(message.getMessageNumber()));
                            this.outboundSequence.acknowledge(message.getMessageNumber());
                        }
                        if (mess != null && !this.isOneWayMessage.booleanValue() && mess.getPayloadNamespaceURI() == null) {
                            logger.log(Level.FINE, Messages.RESENDING_DROPPED_MESSAGE.format(new Object[0]));
                            ret = null;
                        }
                        if (message.isTwoWayRequest) {
                            this.outboundSequence.acknowledgeResponse(message.getMessageNumber());
                        }
                    }
                }
                if (ret == null || !message.isComplete()) {
                    message.block();
                    if (message.isComplete()) {
                        return ret;
                    }
                    this.outboundSequence.ensureAckRequested(message, this.marshaller);
                    continue;
                }
                return ret;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (message != null) {
                this.outboundSequence.acknowledge(message.getMessageNumber());
                if (message.isTwoWayRequest) {
                    this.outboundSequence.acknowledgeResponse(message.getMessageNumber());
                }
            }
            throw e;
        }
    }

    @Override
    public Packet process(Packet packet) {
        Message message = null;
        try {
            this.initialize(packet);
            Object seq = packet.invocationProperties.get("com.sun.xml.ws.createsequence");
            if (seq != null) {
                packet.invocationProperties.put("com.sun.xml.ws.createsequence", null);
                packet.proxy.getRequestContext().put("com.sun.xml.ws.sequence", seq);
                com.sun.xml.ws.api.message.Message mess = com.sun.xml.ws.api.message.Messages.createEmpty(this.binding.getSOAPVersion());
                packet.setMessage(mess);
                return packet;
            }
            Object mn = packet.proxy.getRequestContext().get("com.sun.xml.ws.messagenumber");
            if (mn != null) {
                packet.invocationProperties.put("com.sun.xml.ws.messagenumber", mn);
            }
            message = this.handleOutboundMessage(this.outboundSequence, packet);
            if (!packet.getMessage().isOneWay(this.port)) {
                message.isTwoWayRequest = true;
            }
            return this.doRetryLoop(packet, message);
        }
        catch (RMException e) {
            com.sun.xml.ws.api.message.Message faultMessage = e.getFaultMessage();
            if (faultMessage != null) {
                try {
                    Packet ret = new Packet(com.sun.xml.ws.api.message.Messages.create(faultMessage.readAsSOAPMessage()));
                    ret.invocationProperties.putAll(packet.invocationProperties);
                    return ret;
                }
                catch (SOAPException e1) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            throw new WebServiceException((Throwable)e);
        }
        catch (Throwable ee) {
            logger.log(Level.SEVERE, Messages.UNEXPECTED_PROCESS_EXCEPTION.format(new Object[0]), ee);
            throw new WebServiceException(ee);
        }
    }

    @Override
    public synchronized void preDestroy() {
        try {
            ((RMSource)this.provider).terminateSequence(this.outboundSequence);
            this.nextPipe.preDestroy();
        }
        catch (Exception e) {
            logger.log(Level.FINE, Messages.UNEXPECTED_PREDESTROY_EXCEPTION.format(new Object[0]), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipe copy(PipeCloner cloner) {
        RMClientPipe rMClientPipe = this;
        synchronized (rMClientPipe) {
            return new RMClientPipe(this, cloner);
        }
    }

    private boolean checkForTwoWayOperation() {
        WSDLBoundPortType portType;
        if (this.port == null || null == (portType = this.port.getBinding())) {
            return false;
        }
        for (WSDLBoundOperation wSDLBoundOperation : portType.getBindingOperations()) {
            WSDLOperation operation = wSDLBoundOperation.getOperation();
            if (operation.isOneWay()) continue;
            return true;
        }
        return false;
    }
}

