/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.util;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingHelper {
    private final Logger logger;
    public static final String logRoot = "javax.enterprise.xml.webservices";
    public static final String packageRoot = "com\\.sun\\.xml\\.ws";

    public LoggingHelper(Logger logger) {
        this.logger = logger;
    }

    public <T extends Throwable> void throwAndLog(Class<T> exceptionClass, Level level, String message, boolean stackTrace) throws T {
        Constructor<?>[] ctors;
        Constructor<?> oneArg = null;
        Constructor<?> zeroArg = null;
        for (Constructor<?> ctor : ctors = exceptionClass.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length == 0) {
                zeroArg = ctor;
                continue;
            }
            if (params.length != 1 || !params[0].equals(String.class)) continue;
            oneArg = ctor;
        }
        Throwable exception = null;
        try {
            if (oneArg != null) {
                exception = (Throwable)oneArg.newInstance(message);
            } else if (zeroArg == null) {
                exception = (Throwable)zeroArg.newInstance(new Object[0]);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.logger.isLoggable(level)) {
            if (stackTrace && exception != null) {
                this.logger.log(level, message, exception);
            } else {
                this.logger.log(level, message);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public <T extends Throwable> void throwAndLog(Class<T> exceptionClass, Level level, String message) throws T {
        this.throwAndLog(exceptionClass, level, message, true);
    }

    public static String getLoggerName(Class clasz) {
        return clasz.getName().replaceFirst(packageRoot, logRoot);
    }
}

