/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.IssuedToken,
SecurityAssertionValidator {
    private boolean populated = false;
    protected String includeToken = Token.INCLUDE_ALWAYS;
    private RequestSecurityTokenTemplate rstTemplate;
    private Issuer issuer = null;
    private static QName itQname = new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken");
    private ArrayList<String> referenceType;
    private String id;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean reqDK = false;

    public IssuedToken() {
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
    }

    public IssuedToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
    }

    @Override
    public RequestSecurityTokenTemplate getRequestSecurityTokenTemplate() {
        this.populate();
        return this.rstTemplate;
    }

    @Override
    public Iterator getTokenRefernceType() {
        this.populate();
        return this.referenceType.iterator();
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(itQname) != null) {
                this.includeToken = this.getAttributeValue(itQname);
            }
            if (this.hasNestedAssertions()) {
                Iterator<PolicyAssertion> it = this.getNestedAssertionsIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = it.next();
                    if (PolicyUtil.isIssuer(assertion)) {
                        this.issuer = (Issuer)((Object)assertion);
                        continue;
                    }
                    if (PolicyUtil.isRequestSecurityTokenTemplate(assertion)) {
                        this.rstTemplate = (RequestSecurityTokenTemplate)((Object)assertion);
                        continue;
                    }
                    if (assertion.isOptional()) continue;
                    Constants.log_invalid_assertion(assertion, isServer, "IssuedToken");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            if (as == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, " Nested Policy is empty");
                }
                this.populated = true;
                return this.fitness;
            }
            for (PolicyAssertion assertion : as) {
                if (this.referenceType == null) {
                    this.referenceType = new ArrayList();
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion)) {
                    this.reqDK = true;
                    continue;
                }
                if (PolicyUtil.isRequireExternalReference(assertion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isRequireInternalReference(assertion)) {
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "IssuedToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

