/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IssueSamlTokenContract
implements com.sun.xml.ws.api.security.trust.IssueSamlTokenContract<RequestSecurityToken, RequestSecurityTokenResponse> {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    protected STSConfiguration stsConfig;
    protected static final WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance();
    protected static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'", Locale.getDefault());
    private static final int DEFAULT_KEY_SIZE = 256;
    private long currentTime;

    @Override
    public void init(STSConfiguration stsConfig) {
        this.stsConfig = stsConfig;
    }

    @Override
    public RequestSecurityTokenResponse issue(RequestSecurityToken rst, IssuedTokenContext context) throws WSTrustException {
        Subject subject;
        TrustSPMetadata spMd;
        AppliesTo applies = rst.getAppliesTo();
        String appliesTo = null;
        if (applies != null) {
            appliesTo = WSTrustUtil.getAppliesToURI(applies);
        }
        if ((spMd = this.stsConfig.getTrustSPMetadata(appliesTo)) == null) {
            spMd = this.stsConfig.getTrustSPMetadata("default");
        }
        if (spMd == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
        }
        String tokenType = null;
        URI tokenTypeURI = rst.getTokenType();
        tokenType = tokenTypeURI != null ? tokenTypeURI.toString() : spMd.getTokenType();
        if (tokenType == null) {
            tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
        }
        String keyType = null;
        URI keyTypeURI = rst.getKeyType();
        keyType = keyTypeURI != null ? keyTypeURI.toString() : spMd.getKeyType();
        if (keyType == null) {
            keyType = "http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey";
        }
        if ((subject = context.getRequestorSubject()) == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0030_REQUESTOR_NULL());
            throw new WSTrustException(LogStringsMessages.WST_0030_REQUESTOR_NULL());
        }
        STSAuthorizationProvider authzProvider = WSTrustFactory.getSTSAuthorizationProvider();
        if (!authzProvider.isAuthorized(subject, appliesTo, tokenType, keyType)) {
            String user = subject.getPrincipals().iterator().next().getName();
            log.log(Level.SEVERE, LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
        }
        Claims claims = rst.getClaims();
        STSAttributeProvider attrProvider = WSTrustFactory.getSTSAttributeProvider();
        Map<QName, List<String>> claimedAttrs = attrProvider.getClaimedAttributes(subject, appliesTo, tokenType, claims);
        RequestedProofToken proofToken = null;
        Entropy serverEntropy = null;
        int keySize = 0;
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey".equals(keyType)) {
            proofToken = eleFac.createRequestedProofToken();
            byte[] clientEntr = null;
            Entropy clientEntropy = rst.getEntropy();
            if (clientEntropy != null) {
                BinarySecret clientBS = clientEntropy.getBinarySecret();
                if (clientBS == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, LogStringsMessages.WST_1009_NULL_BINARY_SECRET());
                    }
                } else {
                    clientEntr = clientBS.getRawValue();
                }
            }
            if ((keySize = (int)rst.getKeySize()) < 1) {
                keySize = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1010_KEY_SIZE(keySize, 256));
            }
            byte[] key = WSTrustUtil.generateRandomSecret(keySize / 8);
            BinarySecret serverBS = eleFac.createBinarySecret(key, "http://schemas.xmlsoap.org/ws/2005/02/trust/Nonce");
            serverEntropy = eleFac.createEntropy(serverBS);
            proofToken.setProofTokenType("ComputedKey");
            try {
                proofToken.setComputedKey(URI.create("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1"));
                key = SecurityUtil.P_SHA1(clientEntr, key, keySize / 8);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0013_ERROR_SECRET_KEY("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1", keySize, appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0013_ERROR_SECRET_KEY("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1", keySize, appliesTo), ex);
            }
            context.setProofKey(key);
        } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey".equals(keyType)) {
            Set<Object> certs = context.getRequestorSubject().getPublicCredentials();
            if (certs == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
            boolean addedClientCert = false;
            for (Object o : certs) {
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate clientCert = (X509Certificate)o;
                context.setRequestorCertificate(clientCert);
                addedClientCert = true;
            }
            if (!addedClientCert) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
        }
        URI ctx = null;
        try {
            String rstCtx = rst.getContext();
            if (rstCtx != null) {
                ctx = new URI(rst.getContext());
            }
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
        }
        String assertionId = "uuid-" + UUID.randomUUID().toString();
        RequestedSecurityToken reqSecTok = eleFac.createRequestedSecurityToken();
        Token samlToken = this.createSAMLAssertion(appliesTo, tokenType, keyType, assertionId, this.stsConfig.getIssuer(), claimedAttrs, context);
        reqSecTok.setToken(samlToken);
        SecurityTokenReference samlReference = this.createSecurityTokenReference(assertionId, tokenType);
        RequestedAttachedReference raRef = eleFac.createRequestedAttachedReference(samlReference);
        RequestedUnattachedReference ruRef = eleFac.createRequestedUnattachedReference(samlReference);
        Lifetime lifetime = this.createLifetime();
        RequestSecurityTokenResponse rstr = eleFac.createRSTRForIssue(rst.getTokenType(), ctx, reqSecTok, applies, raRef, ruRef, proofToken, serverEntropy, lifetime);
        if (keySize > 0) {
            rstr.setKeySize(keySize);
        }
        context.setSecurityToken(samlToken);
        context.setAttachedSecurityTokenReference(samlReference);
        context.setUnAttachedSecurityTokenReference(samlReference);
        context.setCreationTime(new Date(this.currentTime));
        context.setExpirationTime(new Date(this.currentTime + this.stsConfig.getIssuedTokenTimeout()));
        return rstr;
    }

    public RequestSecurityTokenResponseCollection issueMultiple(RequestSecurityToken request, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: issueMultiple");
    }

    @Override
    public RequestSecurityTokenResponse renew(RequestSecurityToken request, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: renew");
    }

    @Override
    public RequestSecurityTokenResponse cancel(RequestSecurityToken request, IssuedTokenContext context, Map issuedTokenCtxMap) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: cancel");
    }

    @Override
    public RequestSecurityTokenResponse validate(RequestSecurityToken request, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: validate");
    }

    @Override
    public void handleUnsolicited(RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: handleUnsolicited");
    }

    @Override
    public abstract Token createSAMLAssertion(String var1, String var2, String var3, String var4, String var5, Map<QName, List<String>> var6, IssuedTokenContext var7) throws WSTrustException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lifetime createLifetime() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(((Calendar)cal).getTimeZone());
            long beforeTime = cal.getTimeInMillis();
            this.currentTime = beforeTime - (long)offset;
            cal.setTimeInMillis(this.currentTime);
            AttributedDateTime created = new AttributedDateTime();
            created.setValue(calendarFormatter.format(cal.getTime()));
            AttributedDateTime expires = new AttributedDateTime();
            cal.setTimeInMillis(this.currentTime + this.stsConfig.getIssuedTokenTimeout());
            expires.setValue(calendarFormatter.format(cal.getTime()));
            Lifetime lifetime = eleFac.createLifetime(created, expires);
            return lifetime;
        }
    }

    private SecurityTokenReference createSecurityTokenReference(String id, String tokenType) {
        String valueType = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
        }
        KeyIdentifier ref = eleFac.createKeyIdentifier(valueType, null);
        ref.setValue(id);
        return eleFac.createSecurityTokenReference(ref);
    }
}

