/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coordinator;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.ATSubCoordinator;
import com.sun.xml.ws.tx.common.ActivityIdentifier;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.ContextFactory;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.LocalizationMessages;
import com.sun.xml.ws.tx.coordinator.RegistrationManager;
import com.sun.xml.ws.tx.webservice.member.coord.CreateCoordinationContextType;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class CoordinationManager {
    private static final CoordinationManager instance = new CoordinationManager();
    private static final Map<String, Coordinator> coordinators = new HashMap<String, Coordinator>();
    private static TxLogger logger = TxLogger.getCoordLogger(CoordinationManager.class);

    private CoordinationManager() {
    }

    public static CoordinationManager getInstance() {
        return instance;
    }

    @Nullable
    public Coordinator getCoordinator(@NotNull String id) {
        return coordinators.get(id);
    }

    public void putCoordinator(Coordinator coordinator) {
        coordinators.put(coordinator.getIdValue(), coordinator);
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("putCoordinator", "add activity id:" + coordinator.getIdValue());
        }
    }

    public void removeCoordinator(@NotNull String id) {
        Coordinator c = coordinators.remove(id);
        if (c != null) {
            c.forget();
        }
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("removeCoordinator", "remove activity id:" + id);
        }
    }

    @NotNull
    public Coordinator lookupOrCreateCoordinator(@NotNull CreateCoordinationContextType contextRequest) {
        Coordinator c = contextRequest.getCurrentContext() == null ? this.createCoordinator(null, contextRequest) : this.createSubordinateCoordinator(null, contextRequest);
        this.putCoordinator(c);
        return c;
    }

    @NotNull
    public Coordinator lookupOrCreateCoordinator(@NotNull CoordinationContextInterface context) {
        Coordinator c = this.getCoordinator(context.getIdentifier());
        if (c == null) {
            c = RegistrationManager.getRegistrationCoordinatorStatefulWebServiceManager().resolve(context.getRegistrationService()) == null ? this.createSubordinateCoordinator(context, null) : this.createCoordinator(context, null);
        }
        this.putCoordinator(c);
        return c;
    }

    @NotNull
    private Coordinator createCoordinator(@Nullable CoordinationContextInterface context, @Nullable CreateCoordinationContextType contextRequest) {
        String coordType;
        assert (context == null ^ contextRequest == null);
        if (logger.isLogging(Level.FINER)) {
            logger.entering("CoordinationManager.createCoordinator");
        }
        if ("http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(coordType = contextRequest == null ? context.getCoordinationType() : contextRequest.getCoordinationType())) {
            ATCoordinator coord;
            if (contextRequest == null) {
                coord = context.getRootRegistrationService() == null ? new ATCoordinator(context) : new ATSubCoordinator(context);
            } else {
                ATCoordinator aTCoordinator = coord = contextRequest.getCurrentContext() == null ? new ATCoordinator(ContextFactory.createContext(contextRequest), contextRequest) : new ATSubCoordinator(ContextFactory.createContext(contextRequest), contextRequest);
            }
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("CoordinationManager.createCoordinator id=", coord.getIdValue());
            }
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("CoordinationManager.createCoordinator");
            }
            return coord;
        }
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(coordType)) {
            throw new UnsupportedOperationException(LocalizationMessages.OASIS_UNSUPPORTED_3000());
        }
        throw new UnsupportedOperationException(LocalizationMessages.UNRECOGNIZED_COORDINATION_TYPE_3001(coordType));
    }

    @NotNull
    private Coordinator createSubordinateCoordinator(@Nullable CoordinationContextInterface context, @Nullable CreateCoordinationContextType contextRequest) {
        assert (context == null ^ contextRequest == null);
        if (logger.isLogging(Level.FINER)) {
            logger.entering("CoordinationManager.createSubordinateCoordinator");
        }
        if (context == null) {
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("CoordinationManager.createSubordinateCoordinator");
            }
            return this.createCoordinator(null, contextRequest);
        }
        context.setRootCoordinatorRegistrationService(context.getRegistrationService());
        Coordinator coord = this.createCoordinator(context, null);
        context.setRegistrationService(RegistrationManager.newRegistrationEPR((ActivityIdentifier)coord.getId(), context.getExpires()));
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("CoordinationManager.createSubordinateCoordinator");
        }
        return coord;
    }
}

