/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.c14n.BaseCanonicalizer;
import com.sun.xml.wss.impl.c14n.StAXAttr;
import com.sun.xml.wss.impl.misc.UnsyncByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class EXC14nStAXReaderBasedCanonicalizer
extends BaseCanonicalizer {
    private BaseCanonicalizer.NamespaceContextImpl _exC14NContext = new BaseCanonicalizer.NamespaceContextImpl();
    private List _inclusivePrefixList = null;
    private UnsyncByteArrayOutputStream _tmpBuffer = null;
    private HashSet _visiblyUtilized = new HashSet();
    private int _index = 0;

    public EXC14nStAXReaderBasedCanonicalizer() {
        this._attrResult = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            this._attrs.add(new StAXAttr());
        }
        this._tmpBuffer = new UnsyncByteArrayOutputStream();
    }

    public void canonicalize(XMLStreamReader reader, OutputStream stream, List inclusiveList) throws XMLStreamException, IOException {
        if (reader.hasNext() && reader.getEventType() != 1) {
            throw new XMLStreamException("Reader should point to START_ELEMENT EVENT");
        }
        this.updatedNamespaceContext(reader);
        this._stream = stream;
        this._inclusivePrefixList = inclusiveList;
        int eventType = reader.getEventType();
        do {
            switch (eventType) {
                case 1: {
                    this._exC14NContext.push();
                    ++this._index;
                    this.writeStartElement(reader);
                    break;
                }
                case 2: {
                    this._exC14NContext.pop();
                    --this._index;
                    this.writeEndElement(reader);
                    break;
                }
                case 12: {
                    this.outputTextToWriter(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength(), this._stream);
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace()) break;
                    this.outputTextToWriter(reader.getText(), this._stream);
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 8: {
                    break;
                }
                case 15: {
                    break;
                }
                case 9: {
                    break;
                }
                case 14: {
                    break;
                }
                case 3: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
            }
            eventType = reader.next();
        } while (reader.hasNext() && this._index > 0);
    }

    private void writeStartElement(XMLStreamReader reader) throws IOException {
        AttributeNS eDecl;
        String localName = reader.getLocalName();
        String prefix = reader.getPrefix();
        String uri = reader.getNamespaceURI();
        EXC14nStAXReaderBasedCanonicalizer.writeCharToUtf8('<', this._stream);
        if (prefix == null && uri == null) {
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(localName, this._stream);
        } else if (prefix.length() > 0) {
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(prefix, this._stream);
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(":", this._stream);
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(localName, this._stream);
        }
        this.updatedNamespaceContext(reader);
        this.updateAttributes(reader);
        if (prefix != null) {
            this._visiblyUtilized.add(prefix);
        }
        if (this._elementPrefix.length() > 0 && (eDecl = this._exC14NContext.getNamespaceDeclaration(this._elementPrefix)) != null && !eDecl.isWritten()) {
            eDecl.setWritten(true);
            this._nsResult.add(eDecl);
        }
        if (this._visiblyUtilized.size() > 0) {
            Iterator prefixItr = this._visiblyUtilized.iterator();
            this.populateNamespaceDecl(prefixItr);
        }
        if (this._inclusivePrefixList != null) {
            this.populateNamespaceDecl(this._inclusivePrefixList.iterator());
        }
        if (this._nsResult.size() > 0) {
            BaseCanonicalizer.sort(this._nsResult);
            this.writeAttributesNS(this._nsResult);
        }
        if (this._attrResult.size() > 0) {
            BaseCanonicalizer.sort(this._attrResult);
            this.writeAttributes(this._attrResult);
        }
        EXC14nStAXReaderBasedCanonicalizer.writeCharToUtf8('>', this._stream);
        this._nsResult.clear();
        this._attrResult.clear();
        this._visiblyUtilized.clear();
    }

    private void populateNamespaceDecl(Iterator prefixItr) {
        AttributeNS nsDecl = null;
        while (prefixItr.hasNext()) {
            String prefix = (String)prefixItr.next();
            nsDecl = this._exC14NContext.getNamespaceDeclaration(prefix);
            if (nsDecl == null || nsDecl.isWritten()) continue;
            nsDecl.setWritten(true);
            this._nsResult.add(nsDecl);
        }
    }

    private void updatedNamespaceContext(XMLStreamReader reader) {
        if (reader.getEventType() != 1) {
            return;
        }
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String uri = reader.getNamespaceURI(i);
            this._exC14NContext.declareNamespace(prefix, uri);
        }
    }

    private void updateAttributes(XMLStreamReader reader) throws IOException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String localName = reader.getAttributeLocalName(i);
            String uri = reader.getAttributeNamespace(i);
            String prefix = reader.getAttributePrefix(i);
            String value = reader.getAttributeValue(i);
            StAXAttr attr = this.getAttribute();
            attr.setLocalName(localName);
            attr.setValue(value);
            attr.setPrefix(prefix);
            attr.setUri(uri);
            this._attrResult.add(attr);
        }
    }

    private void writeEndElement(XMLStreamReader reader) throws IOException {
        String localName = reader.getLocalName();
        String prefix = reader.getPrefix();
        String uri = reader.getNamespaceURI();
        EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8("</", this._stream);
        if (prefix == null && uri == null) {
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(localName, this._stream);
        } else if (prefix.length() > 0) {
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(prefix, this._stream);
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(":", this._stream);
            EXC14nStAXReaderBasedCanonicalizer.writeStringToUtf8(localName, this._stream);
        }
        EXC14nStAXReaderBasedCanonicalizer.writeCharToUtf8('>', this._stream);
    }

    protected StAXAttr getAttribute() {
        if (this._attrPos < this._attrs.size()) {
            return (StAXAttr)this._attrs.get(this._attrPos++);
        }
        for (int i = 0; i < 4; ++i) {
            this._attrs.add(new StAXAttr());
        }
        return (StAXAttr)this._attrs.get(this._attrPos++);
    }

    protected void writeAttributesNS(List itr) throws IOException {
        AttributeNS attr = null;
        int size = itr.size();
        for (int i = 0; i < size; ++i) {
            attr = (AttributeNS)itr.get(i);
            this._tmpBuffer.reset();
            this._stream.write(attr.getUTF8Data(this._tmpBuffer));
        }
    }

    protected void writeAttributes(List itr) throws IOException {
        int size = itr.size();
        for (int i = 0; i < size; ++i) {
            StAXAttr attr = (StAXAttr)itr.get(i);
            String prefix = attr.getPrefix();
            if (prefix.length() != 0) {
                EXC14nStAXReaderBasedCanonicalizer.outputAttrToWriter(prefix, attr.getLocalName(), attr.getValue(), this._stream);
                continue;
            }
            prefix = attr.getLocalName();
            EXC14nStAXReaderBasedCanonicalizer.outputAttrToWriter(prefix, attr.getValue(), this._stream);
        }
    }
}

