/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.assembler.ClientPipeConfiguration;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSCPlugin;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.PolicyResolverImpl;
import com.sun.xml.wss.jaxws.impl.SecurityPipeBase;
import com.sun.xml.wss.jaxws.impl.logging.LogStringsMessages;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClientPipe
extends SecurityPipeBase
implements SecureConversationInitiator {
    private static TrustPlugin trustPlugin = WSTrustFactory.newTrustPlugin(null);
    private static WSSCPlugin scPlugin = WSSCFactory.newSCPlugin(null);
    private Set trustConfig = null;

    public SecurityClientPipe(ClientPipeConfiguration config, Pipe nextPipe) {
        super(config, nextPipe);
        CallbackHandler handler = null;
        try {
            Iterator it = this.outMessagePolicyMap.values().iterator();
            SecurityPolicyHolder holder = (SecurityPolicyHolder)it.next();
            Set configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/client");
            this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/client");
            Properties props = new Properties();
            handler = this.configureClientHandler(configAssertions, props);
            this.secEnv = new DefaultSecurityEnvironmentImpl(handler, props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0023_ERROR_CREATING_NEW_INSTANCE_SEC_CLIENT_PIPE(), e);
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0023_ERROR_CREATING_NEW_INSTANCE_SEC_CLIENT_PIPE(), e);
        }
    }

    protected SecurityClientPipe(SecurityClientPipe that) {
        super(that);
        this.trustConfig = that.trustConfig;
    }

    @Override
    public Packet process(Packet packet) {
        boolean isTrustMsg = false;
        if ("true".equals(packet.invocationProperties.get("isTrustMessage"))) {
            isTrustMsg = true;
            String action = (String)packet.invocationProperties.get("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
            HeaderList headers = packet.getMessage().getHeaders();
            headers.fillRequestAddressingHeaders(packet, this.addVer, this.soapVersion, false, action);
        }
        Message msg = packet.getMessage();
        boolean isSCMessage = this.isSCMessage(packet);
        if (!isSCMessage && !this.isSCCancel(packet)) {
            this.invokeSCPlugin(packet);
        }
        this.invokeTrustPlugin(packet, isSCMessage);
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(packet, isSCMessage);
        try {
            if (!this.optimized) {
                if (!isSCMessage) {
                    this.cacheOperation(msg);
                }
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                msg = Messages.create(soapMessage);
            } else {
                msg = this.secureOutboundMessage(msg, ctx);
            }
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0024_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSSPIPE_0024_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se);
        }
        packet.setMessage(msg);
        Packet ret = this.nextPipe.process(packet);
        if (ret == null || ret.getMessage() == null) {
            return ret;
        }
        if (!this.optimized) {
            try {
                SOAPMessage sm = ret.getMessage().readAsSOAPMessage();
                Message newMsg = Messages.create(sm);
                ret.setMessage(newMsg);
            }
            catch (SOAPException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0005_PROBLEM_PROC_SOAP_MESSAGE(), ex);
                throw new WebServiceException(LogStringsMessages.WSSPIPE_0005_PROBLEM_PROC_SOAP_MESSAGE(), (Throwable)ex);
            }
        }
        ctx = this.initializeInboundProcessingContext(ret);
        ctx.setExtraneousProperty("OperationResolver", new PolicyResolverImpl(this.inMessagePolicyMap, this.inProtocolPM, this.cachedOperation, this.pipeConfig, this.addVer, true));
        try {
            msg = ret.getMessage();
            if (msg == null) {
                return ret;
            }
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                if (msg.isFault()) {
                    if (debug) {
                        DumpFilter.process(ctx);
                    }
                    SOAPFault fault = soapMessage.getSOAPBody().getFault();
                    throw new SOAPFaultException(fault);
                }
                msg = Messages.create(soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (XWSSecurityException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0025_ERROR_VERIFY_INBOUND_MSG(), xwse);
            throw new WebServiceException(LogStringsMessages.WSSPIPE_0025_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(xwse));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0025_ERROR_VERIFY_INBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSSPIPE_0025_ERROR_VERIFY_INBOUND_MSG(), (Throwable)se);
        }
        this.resetCachedOperation();
        ret.setMessage(msg);
        if (isTrustMsg) {
            this.getAction(ret);
        }
        return ret;
    }

    private void invokeSCPlugin(Packet packet) {
        List<PolicyAssertion> policies = this.getOutBoundSCP(packet.getMessage());
        for (PolicyAssertion scAssertion : policies) {
            Token scToken = (Token)((Object)scAssertion);
            if (this.issuedTokenContextMap.get(scToken.getTokenId()) != null) continue;
            IssuedTokenContext ctx = scPlugin.process(scAssertion, this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), this, this.marshaller, this.unmarshaller, packet.endpointAddress.toString(), packet, this.addVer);
            this.issuedTokenContextMap.put(((Token)((Object)scAssertion)).getTokenId(), ctx);
        }
    }

    protected List<PolicyAssertion> getIssuedTokenPolicies(Packet packet, String scope) {
        if (this.outMessagePolicyMap == null) {
            return new ArrayList<PolicyAssertion>();
        }
        WSDLBoundOperation operation = null;
        operation = this.isTrustMessage(packet) ? this.getWSDLOpFromAction(packet, false) : this.getOperation(packet.getMessage());
        SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(operation);
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getIssuedTokens();
    }

    @Override
    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        List<PolicyAssertion> toks = this.getOutBoundSCP(packet.getMessage());
        if (toks.isEmpty()) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0026_NO_POLICY_FOUND_FOR_SC());
            throw new WSSecureConversationException(LogStringsMessages.WSSPIPE_0026_NO_POLICY_FOUND_FOR_SC());
        }
        Token tok = (Token)((Object)toks.get(0));
        IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(tok.getTokenId());
        if (ctx == null) {
            ctx = scPlugin.process((PolicyAssertion)((Object)tok), this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), this, this.marshaller, this.unmarshaller, packet.endpointAddress.toString(), packet, this.addVer);
            ctx.setEndpointAddress(packet.endpointAddress.toString());
            this.issuedTokenContextMap.put(tok.getTokenId(), ctx);
        }
        SecurityTokenReference str = (SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference();
        return WSTrustElementFactory.newInstance().toJAXBElement(str);
    }

    private void cancelSecurityContextToken() {
        Enumeration keys = this.issuedTokenContextMap.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(id);
            if (!(ctx.getSecurityToken() instanceof SecurityContextToken)) continue;
            ctx = scPlugin.processCancellation(ctx, this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), this, this.marshaller, this.unmarshaller, ctx.getEndpointAddress(), this.addVer);
            this.issuedTokenContextMap.remove(id);
        }
    }

    @Override
    public void preDestroy() {
        this.cancelSecurityContextToken();
        if (this.nextPipe != null) {
            this.nextPipe.preDestroy();
        }
        this.issuedTokenContextMap.clear();
    }

    @Override
    public Pipe copy(PipeCloner cloner) {
        Pipe clonedNextPipe = cloner.copy(this.nextPipe);
        SecurityClientPipe copied = new SecurityClientPipe(this);
        copied.setNextPipe(clonedNextPipe);
        cloner.add(this, copied);
        return copied;
    }

    private void invokeTrustPlugin(Packet packet, boolean isSCMessage) {
        List<PolicyAssertion> policies = null;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            policies = this.getIssuedTokenPoliciesFromBootstrapPolicy(scToken);
        } else {
            policies = this.getIssuedTokenPolicies(packet, Constants.OPERATION_SCOPE);
        }
        PolicyAssertion preSetSTSAssertion = null;
        Object stsEP = null;
        Object wsdlLocation = null;
        Object serviceName = null;
        Object portName = null;
        if (this.trustConfig != null) {
            Iterator it = this.trustConfig.iterator();
            while (it != null && it.hasNext()) {
                preSetSTSAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion issuedTokenAssertion : policies) {
            IssuedTokenContext ctx = trustPlugin.process(issuedTokenAssertion, preSetSTSAssertion, packet.endpointAddress.toString());
            this.issuedTokenContextMap.put(((Token)((Object)issuedTokenAssertion)).getTokenId(), ctx);
        }
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, false);
        this.outMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, true);
        this.inMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.inProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, true, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.outProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, false, true));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (!inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private CallbackHandler configureClientHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Class handler = this.loadClass(ret);
                Object obj = handler.newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSSPIPE_0033_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            return new DefaultCallbackHandler("client", props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0027_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0027_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
        }
    }
}

