/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.common.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class JMXConnectionProperties {
    public static final String USERNAME_PROP = "com.sun.jbi.tools.remote.jmx.username";
    public static final String PASSWORD_PROP = "com.sun.jbi.tools.remote.jmx.password";
    public static final String HOST_PROP = "com.sun.jbi.tools.remote.jmx.host";
    public static final String PORT_PROP = "com.sun.jbi.tools.remote.jmx.port";
    public static final String URL_PROP = "com.sun.jbi.tools.remote.jmx.url";
    public static final String CONNECTION_FACTORY_PROP = "com.sun.jbi.tools.jmx.connection.factory";
    private static JMXConnectionProperties sConnProps;
    private static Properties sDefProps;

    private JMXConnectionProperties() {
    }

    private Properties getDefaultProperties() {
        if (sDefProps == null) {
            try {
                sDefProps = new Properties();
                sDefProps.load(this.getClass().getResourceAsStream("JMXConnection.properties"));
            }
            catch (IOException ex) {
                Util.logDebug(ToolsLogManager.getClientLogger(), ex);
            }
        }
        return sDefProps;
    }

    private String getProperty(String property) {
        String defValue = this.getDefaultProperties().getProperty(property);
        String value = System.getProperty(property, defValue);
        return value;
    }

    public static JMXConnectionProperties getInstance() {
        if (sConnProps == null) {
            sConnProps = new JMXConnectionProperties();
        }
        return sConnProps;
    }

    public String getDefaultUserName() {
        String value = this.getProperty(USERNAME_PROP);
        return value;
    }

    public String getDefaultPassword() {
        String value = this.getProperty(PASSWORD_PROP);
        return value;
    }

    public String getDefaultConnectionFactory() {
        String value = this.getProperty(CONNECTION_FACTORY_PROP);
        return value;
    }

    public String getHost() {
        String value = this.getProperty(HOST_PROP);
        return value;
    }

    public String getPort() {
        String value = this.getProperty(PORT_PROP);
        return value;
    }

    public String getURLFormat() {
        String value = this.getProperty(URL_PROP);
        return value;
    }

    public String getConnectionURL() {
        return this.getConnectionURL(null, null, null);
    }

    public String getConnectionURL(String aHost, String aPort) {
        return this.getConnectionURL(null, aHost, aPort);
    }

    public String getConnectionURL(String aUrl, String aHost, String aPort) {
        String urlFormat = null;
        String host = null;
        String port = null;
        host = aHost == null ? this.getHost() : aHost;
        port = aPort == null ? this.getPort() : aPort;
        urlFormat = aUrl == null ? this.getURLFormat() : aUrl;
        String[] args = new String[]{host, port};
        String url = null;
        try {
            MessageFormat mf = new MessageFormat(urlFormat);
            url = mf.format(args);
        }
        catch (Exception ex) {
            Util.logDebug(ToolsLogManager.getClientLogger(), ex);
        }
        return url;
    }

    public static Properties getJMXConnectionPropertyMap(String url, String host, String port, String username, String password) {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty(USERNAME_PROP, username);
        }
        if (password != null) {
            props.setProperty(PASSWORD_PROP, password);
        }
        if (host != null) {
            props.setProperty(HOST_PROP, host);
        }
        if (port != null) {
            props.setProperty(PORT_PROP, port);
        }
        if (url != null) {
            props.setProperty(URL_PROP, url);
        }
        return props;
    }

    public static Properties getJMXConnectionPropertyMap(String confac, Properties provprops, String url, String host, String port, String username, String password) {
        Properties props = JMXConnectionProperties.getJMXConnectionPropertyMap(url, host, port, username, password);
        if (provprops != null) {
            try {
                props.putAll((Map<?, ?>)provprops);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (confac != null) {
            props.put(CONNECTION_FACTORY_PROP, confac);
        }
        return props;
    }

    public static Properties getJMXConnectionPropertyMap(Properties provprops, String url, String host, String port, String username, String password) {
        Properties props = JMXConnectionProperties.getJMXConnectionPropertyMap(url, host, port, username, password);
        if (provprops != null) {
            try {
                props.putAll((Map<?, ?>)provprops);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return props;
    }
}

