/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class JBIJMXObjectNames {
    public static final String JMX_JBI_DOMAIN = "com.sun.jbi";
    public static final String CONTROL_TYPE_KEY = "ControlType";
    public static final String DEPLOYER_CONTROL_TYPE_VALUE = "Deployer";
    public static final String INSTALLER_CONTROL_TYPE_VALUE = "Installer";
    public static final String LIFECYCLE_CONTROL_TYPE_VALUE = "Lifecycle";
    public static final String CONTROLLER_CONTROL_TYPE_VALUE = "Controller";
    public static final String ADMIN_SERVICE_CONTROL_TYPE_VALUE = "AdministrationService";
    public static final String COMPONENT_TYPE_KEY = "ComponentType";
    public static final String SYSTEM_COMPONENT_TYPE_VALUE = "System";
    public static final String INSTALL_COMPONENT_TYPE_VALUE = "Installed";
    public static final String INSTALLED_TYPE_KEY = "InstalledType";
    public static final String ENGINE_INSTALLED_TYPE_VALUE = "Engine";
    public static final String BINDING_INSTALLED_TYPE_VALUE = "Binding";
    public static final String COMPONENT_ID_KEY = "ComponentName";
    public static final String SERVICE_NAME_KEY = "ServiceName";
    public static final String ADMIN_SERVICE = "AdminService";
    public static final String DEPLOYMENT_SERVICE = "DeploymentService";
    public static final String INSTALLATION_SERVICE = "InstallationService";
    public static final String CONFIGURATION_SERVICE = "ConfigurationService";
    public static final String JBI_ADMIN_UI_SERVICE = "JbiAdminUiService";
    public static final String JBI_REFERENCE_ADMIN_UI_SERVICE = "JbiReferenceAdminUiService";
    public static final String TARGET_KEY = "Target";
    public static final String SERVICE_TYPE_KEY = "ServiceType";
    public static final String COMPONENT_LIFECYCLE_KEY = "ComponentLifeCycle";
    private static String sJbiJmxDomain = null;
    private static ObjectName sAdminMBeanObjectName = null;
    private static ObjectName sUiMBeanObjectName = null;
    private static ObjectName sReferenceUiMBeanObjectName = null;

    public static String getJbiJmxDomain() {
        if (sJbiJmxDomain == null) {
            sJbiJmxDomain = System.getProperty("jbi.jmx.domain", JMX_JBI_DOMAIN);
        }
        return sJbiJmxDomain;
    }

    public static ObjectName getJbiAdminUiMBeanObjectName() throws MalformedObjectNameException {
        if (sUiMBeanObjectName == null) {
            String mbeanRegisteredName = JBIJMXObjectNames.getJbiJmxDomain() + ":" + SERVICE_NAME_KEY + "=" + JBI_ADMIN_UI_SERVICE + "," + COMPONENT_TYPE_KEY + "=" + SYSTEM_COMPONENT_TYPE_VALUE;
            sUiMBeanObjectName = new ObjectName(mbeanRegisteredName);
        }
        return sUiMBeanObjectName;
    }

    public static ObjectName getJbiReferenceAdminUiMBeanObjectName() throws MalformedObjectNameException {
        if (sReferenceUiMBeanObjectName == null) {
            String mbeanRegisteredName = JBIJMXObjectNames.getJbiJmxDomain() + ":" + SERVICE_NAME_KEY + "=" + JBI_REFERENCE_ADMIN_UI_SERVICE + "," + COMPONENT_TYPE_KEY + "=" + SYSTEM_COMPONENT_TYPE_VALUE;
            sReferenceUiMBeanObjectName = new ObjectName(mbeanRegisteredName);
        }
        return sReferenceUiMBeanObjectName;
    }

    public static ObjectName getAdminServiceMBeanObjectName() throws MalformedObjectNameException {
        if (sAdminMBeanObjectName == null) {
            String mbeanRegisteredName = JBIJMXObjectNames.getJbiJmxDomain() + ":" + SERVICE_NAME_KEY + "=" + ADMIN_SERVICE + "," + CONTROL_TYPE_KEY + "=" + ADMIN_SERVICE_CONTROL_TYPE_VALUE + "," + COMPONENT_TYPE_KEY + "=" + SYSTEM_COMPONENT_TYPE_VALUE;
            sAdminMBeanObjectName = new ObjectName(mbeanRegisteredName);
        }
        return sAdminMBeanObjectName;
    }

    public static ObjectName getComponentLifeCycleMBeanObjectNamePattern(String componentName) throws MalformedObjectNameException {
        String lifecycleObjectNamePatternString = JBIJMXObjectNames.getJbiJmxDomain() + ":" + CONTROL_TYPE_KEY + "=" + LIFECYCLE_CONTROL_TYPE_VALUE + "," + COMPONENT_ID_KEY + "=" + componentName + "," + "*";
        ObjectName lifecycleObjectNamePattern = new ObjectName(lifecycleObjectNamePatternString);
        return lifecycleObjectNamePattern;
    }

    public static ObjectName getComponentLifeCycleMBeanObjectNamePattern(String componentName, String targetName) throws MalformedObjectNameException {
        String lifecycleObjectNamePatternString = JBIJMXObjectNames.getJbiJmxDomain() + ":" + TARGET_KEY + "=" + targetName + "," + SERVICE_TYPE_KEY + "=" + COMPONENT_LIFECYCLE_KEY + "," + COMPONENT_ID_KEY + "=" + componentName + "," + "*";
        ObjectName lifecycleObjectNamePattern = new ObjectName(lifecycleObjectNamePatternString);
        return lifecycleObjectNamePattern;
    }

    public static ObjectName getComponentDeployerMBeanObjectNamePattern(String componentName) throws MalformedObjectNameException {
        String lifecycleObjectNamePatternString = JBIJMXObjectNames.getJbiJmxDomain() + ":" + CONTROL_TYPE_KEY + "=" + DEPLOYER_CONTROL_TYPE_VALUE + "," + COMPONENT_ID_KEY + "=" + componentName + "," + "*";
        ObjectName lifecycleObjectNamePattern = new ObjectName(lifecycleObjectNamePatternString);
        return lifecycleObjectNamePattern;
    }
}

