/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.JBIDescriptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceAssemblyDD
extends JBIDescriptor {
    Identification mIdInfo;
    private List mServiceUnitDDList;

    protected ServiceAssemblyDD(Identification idInfo, List suDDList) {
        this.mIdInfo = idInfo;
        this.mServiceUnitDDList = suDDList != null ? Collections.unmodifiableList(suDDList) : new ArrayList();
    }

    public String getName() {
        return this.mIdInfo.getName();
    }

    public String getDescription() {
        return this.mIdInfo.getDescription();
    }

    public List getServiceUnitDDList() {
        return this.mServiceUnitDDList;
    }

    public boolean isSharedLibraryDescriptor() {
        return false;
    }

    public boolean isServiceEngineDescriptor() {
        return false;
    }

    public boolean isBindingComponentDescriptor() {
        return false;
    }

    public boolean isServiceAssemblyDescriptor() {
        return true;
    }

    public String toString() {
        return "Name : " + this.getName() + "\n" + "Description : " + this.getDescription() + "\n" + "Service Units : " + this.getServiceUnitDDList().size();
    }

    public void printServiceAssembly(PrintStream out) {
        out.println(this);
        List list = this.getServiceUnitDDList();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            out.println(itr.next());
        }
    }

    public static ServiceAssemblyDD createServiceAssemblyDD(Identification idInfo, List suDDList) {
        return new ServiceAssemblyDD(idInfo, suDDList);
    }

    public static ServiceAssemblyDD createServiceAssemblyDD(Element saEl) {
        Identification idInfo = null;
        ArrayList<ServiceUnitDD> suDDList = null;
        Element idInfoEl = DOMUtil.UTIL.getChildElement(saEl, "identification");
        if (idInfoEl != null) {
            idInfo = Identification.createIdentification(idInfoEl);
        }
        suDDList = new ArrayList<ServiceUnitDD>();
        NodeList suNodeList = DOMUtil.UTIL.getChildElements(saEl, "service-unit");
        int size = suNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element suEl = (Element)suNodeList.item(i);
            if (suEl == null) continue;
            ServiceUnitDD suDD = ServiceUnitDD.createServiceUnitDD(suEl);
            suDDList.add(suDD);
        }
        return ServiceAssemblyDD.createServiceAssemblyDD(idInfo, suDDList);
    }

    public static class Identification {
        private String mName;
        private String mDesc;

        protected Identification(String name, String desc) {
            this.mName = name;
            this.mDesc = desc;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDesc;
        }

        public String toString() {
            return "Name : " + this.getName() + "\n" + "Description : " + this.getDescription();
        }

        public static Identification createIdentification(String name, String desc) {
            return new Identification(name, desc);
        }

        public static Identification createIdentification(Element idInfoEl) {
            Element descEl;
            String name = null;
            String desc = null;
            Element nameEl = DOMUtil.UTIL.getElement(idInfoEl, "name");
            if (nameEl != null) {
                name = DOMUtil.UTIL.getTextData(nameEl);
            }
            if ((descEl = DOMUtil.UTIL.getElement(idInfoEl, "description")) != null) {
                desc = DOMUtil.UTIL.getTextData(descEl);
            }
            return Identification.createIdentification(name, desc);
        }
    }

    public static class ServiceUnitDD {
        Identification mIdInfo;
        private String mTargetName;

        protected ServiceUnitDD(Identification idInfo, String targetName) {
            this.mIdInfo = idInfo;
            this.mTargetName = targetName;
        }

        public String getName() {
            return this.mIdInfo.getName();
        }

        public String getDescription() {
            return this.mIdInfo.getDescription();
        }

        public String getTargetName() {
            return this.mTargetName;
        }

        public String toString() {
            return "Name : " + this.getName() + "\n" + "Description : " + this.getDescription() + "\n" + "TargetName : " + this.getTargetName();
        }

        public static ServiceUnitDD createServiceUnitDD(Identification idInfo, String targetName) {
            return new ServiceUnitDD(idInfo, targetName);
        }

        public static ServiceUnitDD createServiceUnitDD(Element suEl) {
            Element targetNameEl;
            Identification idInfo = null;
            String targetName = null;
            Element idInfoEl = DOMUtil.UTIL.getElement(suEl, "identification");
            if (idInfoEl != null) {
                idInfo = Identification.createIdentification(idInfoEl);
            }
            if ((targetNameEl = DOMUtil.UTIL.getElement(suEl, "component-name")) != null) {
                targetName = DOMUtil.UTIL.getTextData(targetNameEl);
            }
            return ServiceUnitDD.createServiceUnitDD(idInfo, targetName);
        }
    }
}

