/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.security.sasl.util;

import java.util.Map;

public final class PolicyUtils {
    public static final int NOPLAINTEXT = 1;
    public static final int NOACTIVE = 2;
    public static final int NODICTIONARY = 4;
    public static final int FORWARD_SECRECY = 8;
    public static final int NOANONYMOUS = 16;
    public static final int PASS_CREDENTIALS = 512;

    private PolicyUtils() {
    }

    public static boolean checkPolicy(int flags, Map props) {
        if (props == null) {
            return true;
        }
        if ("true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.noplaintext")) && (flags & 1) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.noactive")) && (flags & 2) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.nodictionary")) && (flags & 4) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.noanonymous")) && (flags & 0x10) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.forward")) && (flags & 8) == 0) {
            return false;
        }
        return !"true".equalsIgnoreCase((String)props.get("javax.security.sasl.policy.credentials")) || (flags & 0x200) != 0;
    }

    public static String[] filterMechs(String[] mechs, int[] policies, Map props) {
        if (props == null) {
            return (String[])mechs.clone();
        }
        boolean[] passed = new boolean[mechs.length];
        int count = 0;
        for (int i = 0; i < mechs.length; ++i) {
            passed[i] = PolicyUtils.checkPolicy(policies[i], props);
            if (!passed[i]) continue;
            ++count;
        }
        String[] answer = new String[count];
        int j = 0;
        for (int i = 0; i < mechs.length; ++i) {
            if (!passed[i]) continue;
            answer[j++] = mechs[i];
        }
        return answer;
    }
}

