/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiQueryTask;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class JbiListSharedLibrariesTask
extends JbiQueryTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.shared.lib.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.shared.lib.failed";
    private String mSharedLibraryName;
    private String mComponentName;

    public String getSharedLibraryName() {
        return this.mSharedLibraryName;
    }

    public void setSharedLibraryName(String sharedLibraryName) {
        this.mSharedLibraryName = sharedLibraryName;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public void executeTask() throws BuildException {
        this.initXmlOutput(JBIComponentInfo.writeAsXmlText(new ArrayList()));
        String target = this.getValidTarget();
        try {
            String result;
            String name = this.getSharedLibraryName();
            String compName = this.getComponentName();
            if (null != name && name.length() > 0) {
                result = this.getJBIAdminCommands().showSharedLibrary(name, compName, target);
                this.setSingleQueryResultType();
            } else {
                result = this.getJBIAdminCommands().listSharedLibraries(compName, target);
            }
            this.printComponentQueryResults(result);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey() {
        return "jbi.ui.ant.print.no.slib";
    }

    protected String getQueryResultHeaderI18NKey() {
        return "jbi.ui.ant.print.slib.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.separator";
    }

    protected String getEmptyQueryResultI18NMessage() {
        if (this.getQueryResultType() == 2) {
            return this.getI18NBundle().getMessage("jbi.ui.ant.print.no.slib.with.name", this.getSharedLibraryName());
        }
        return this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey());
    }
}

