/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Echo;

public class I18NEchoTask
extends Echo {
    private static final String DEFAULT_BUNDLE = "com.sun.jbi.ui.ant.util.Bundle";
    private String mBundle;
    private String mKey;
    private List mArgList;

    public String getBundle() {
        return this.mBundle == null ? DEFAULT_BUNDLE : this.mBundle;
    }

    public void setBundle(String bundle) {
        this.mBundle = bundle;
    }

    public String getKey() {
        return this.mKey;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public Argument createArg() {
        if (this.mArgList == null) {
            this.mArgList = new ArrayList();
        }
        Argument arg = new Argument();
        this.mArgList.add(arg);
        return arg;
    }

    protected String[] getArguments() {
        if (this.mArgList == null) {
            this.mArgList = new ArrayList();
        }
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < this.mArgList.size(); ++i) {
            args.add(((Argument)this.mArgList.get(i)).getValue());
        }
        return args.toArray(new String[args.size()]);
    }

    public void execute() throws BuildException {
        String i18nKey = this.getKey();
        String bundleBase = this.getBundle();
        String msg = null;
        if (i18nKey != null) {
            msg = this.loadMessageFromBundle(bundleBase, i18nKey, this.getArguments());
        }
        if (msg != null) {
            this.setMessage(msg);
        }
        super.execute();
    }

    private String loadMessageFromBundle(String bundleBase, String key, String[] args) throws BuildException {
        String i18nMessage = this.loadBundle(bundleBase).getString(key);
        MessageFormat mf = new MessageFormat(i18nMessage);
        String formattedI18NMsg = mf.format(args);
        return formattedI18NMsg;
    }

    private ResourceBundle loadBundle(String bundleBase) throws BuildException {
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle(bundleBase);
        }
        catch (MissingResourceException ex) {
            this.log("I18NEchoTask MissingResourceException loading  " + bundleBase + " Message : " + ex.getMessage(), 4);
            this.log("Trying to load Locale independent default Bundle ", 4);
            resBundle = ResourceBundle.getBundle(bundleBase, new Locale(""));
        }
        if (resBundle != null) {
            this.log("I18NEchoTask got resource bundle with Locale " + resBundle.getLocale(), 4);
        } else {
            this.log("I18NEchoTask got null resource bundle for bundel base " + bundleBase, 4);
        }
        return resBundle;
    }

    public static class Argument {
        private String mValue = "";

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String value) {
            if (value == null) {
                value = "";
            }
            this.mValue = value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

