/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNotificationSignalImpl
implements JoinNotificationSignal {
    private String memberToken;
    private String groupName;
    private List<String> currentCoreMembers;
    private List<String> allCurrentMembers;
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private static GMSContext ctx;
    protected static final Logger logger;
    private long startTime;

    public JoinNotificationSignalImpl(String memberToken, List<String> currentCoreMembers, List<String> allCurrentMembers, String groupName, long startTime) {
        this.memberToken = memberToken;
        this.currentCoreMembers = currentCoreMembers;
        this.allCurrentMembers = allCurrentMembers;
        this.groupName = groupName;
        this.startTime = startTime;
        ctx = GMSContextFactory.getGMSContext(groupName);
    }

    JoinNotificationSignalImpl(JoinNotificationSignal signal) {
        this.memberToken = signal.getMemberToken();
        this.currentCoreMembers = signal.getCurrentCoreMembers();
        this.allCurrentMembers = signal.getAllCurrentMembers();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        this.memberToken = null;
        this.currentCoreMembers = null;
        this.allCurrentMembers = null;
    }

    @Override
    public String getMemberToken() {
        return this.memberToken;
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        return this.currentCoreMembers;
    }

    @Override
    public List<String> getAllCurrentMembers() {
        return this.allCurrentMembers;
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails() {
        DistributedStateCache dsc;
        HashMap<Serializable, Serializable> ret = new HashMap();
        if (ctx == null) {
            ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        if ((dsc = ctx.getDistributedStateCache()) != null) {
            ret = dsc.getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
        } else {
            logger.log(Level.WARNING, "no.instance.dsc", new Object[]{this.memberToken});
        }
        return ret;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    static {
        logger = GMSLogDomain.getLogger("ShoalLogger");
    }
}

