/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterView {
    private static final Logger LOG = JxtaUtil.getLogger(ClusterView.class.getName());
    private final TreeMap<String, SystemAdvertisement> view;
    private final long viewId;
    private ReentrantLock viewLock = new ReentrantLock(true);

    ClusterView(TreeMap<String, SystemAdvertisement> advertisements, long viewId) {
        this.view = new TreeMap<String, SystemAdvertisement>((SortedMap<String, SystemAdvertisement>)advertisements);
        this.viewId = viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterView(SystemAdvertisement advertisement) {
        this.view = new TreeMap();
        this.lockLog("constructor()");
        this.viewLock.lock();
        try {
            this.view.put(advertisement.getID().toString(), advertisement);
        }
        finally {
            this.viewLock.unlock();
        }
        this.viewId = 0L;
    }

    public SystemAdvertisement get(ID id) {
        return this.view.get(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SystemAdvertisement adv) {
        this.lockLog("add()");
        this.viewLock.lock();
        try {
            this.view.put(adv.getID().toString(), adv);
        }
        finally {
            this.viewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ID id) {
        boolean hasKey = false;
        this.lockLog("containsKey()");
        this.viewLock.lock();
        try {
            hasKey = this.view.containsKey(id.toString());
        }
        finally {
            this.viewLock.unlock();
        }
        return hasKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SystemAdvertisement> getView() {
        ArrayList<SystemAdvertisement> viewCopy;
        this.lockLog("getView()");
        this.viewLock.lock();
        try {
            viewCopy = new ArrayList<SystemAdvertisement>(this.view.values());
        }
        finally {
            this.viewLock.unlock();
        }
        return viewCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPeerNamesInView() {
        ArrayList<String> peerNamesList;
        this.lockLog("getPeerNamesInView()");
        this.viewLock.lock();
        try {
            peerNamesList = new ArrayList<String>(this.view.keySet());
        }
        finally {
            this.viewLock.unlock();
        }
        return peerNamesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int size = 0;
        this.lockLog("getSize()");
        this.viewLock.lock();
        try {
            size = this.view.size();
        }
        finally {
            this.viewLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAdvertisement getMasterCandidate() {
        this.lockLog("getMasterCandidate()");
        this.viewLock.lock();
        try {
            String id = this.view.firstKey();
            SystemAdvertisement adv = this.view.get(id);
            LOG.log(Level.FINE, new StringBuffer().append("Returning Master Candidate Node :").append(adv.getName()).append(' ').append(adv.getID()).toString());
            SystemAdvertisement systemAdvertisement = adv;
            return systemAdvertisement;
        }
        finally {
            this.viewLock.unlock();
        }
    }

    public boolean isFirst(SystemAdvertisement advertisement) {
        String id = this.view.firstKey();
        return advertisement.getID().toString().equals(id);
    }

    public long getClusterViewId() {
        return this.viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lockLog("clear()");
        this.viewLock.lock();
        try {
            this.view.clear();
        }
        finally {
            this.viewLock.unlock();
        }
    }

    private void lockLog(String method) {
        LOG.log(Level.FINE, MessageFormat.format("{0} viewLock Hold count :{1}, lock queue count:{2}", method, this.viewLock.getHoldCount(), this.viewLock.getQueueLength()));
    }
}

