/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.spi.codegen.ClassInfo;
import com.sun.corba.ee.spi.codegen.MemberInfo;
import java.lang.reflect.Modifier;

public class MemberInfoBase
implements MemberInfo {
    private ClassInfo myClassInfo;
    private int modifiers;
    private String name;

    public MemberInfoBase(ClassInfo myClassInfo, int modifiers, String name) {
        this.myClassInfo = myClassInfo;
        this.modifiers = modifiers;
        this.name = name;
    }

    public ClassInfo myClassInfo() {
        return this.myClassInfo;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public String name() {
        return this.name;
    }

    public boolean isAccessibleInContext(ClassInfo definingClass, ClassInfo accessClass) {
        if (Modifier.isPublic(this.modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(this.modifiers)) {
            return this.myClassInfo.name().equals(definingClass.name());
        }
        if (Modifier.isProtected(this.modifiers)) {
            if (this.myClassInfo.pkgName().equals(definingClass.pkgName())) {
                return true;
            }
            return definingClass.isSubclass(this.myClassInfo) && accessClass.isSubclass(definingClass);
        }
        return this.myClassInfo.pkgName().equals(definingClass.pkgName());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.modifiers;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MemberInfo other = (MemberInfo)MemberInfo.class.cast(obj);
        return this.name.equals(other.name()) && this.modifiers == other.modifiers();
    }

    public String toString() {
        return this.getClass().getName() + "[" + Modifier.toString(this.modifiers) + this.name + "]";
    }
}

