/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm.attrs;

import com.sun.corba.ee.org.objectweb.asm.Attribute;
import com.sun.corba.ee.org.objectweb.asm.ByteVector;
import com.sun.corba.ee.org.objectweb.asm.ClassReader;
import com.sun.corba.ee.org.objectweb.asm.ClassWriter;
import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.attrs.StackMapFrame;
import java.util.ArrayList;
import java.util.HashSet;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public ArrayList frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame frame = (StackMapFrame)this.frames.get(i);
            if (frame.label != label) continue;
            return frame;
        }
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isCodeAttribute() {
        return true;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = new StackMapAttribute();
        int codeSize = cr.readInt(codeOff + 4);
        int size = 0;
        if (codeSize > 65535) {
            size = cr.readInt(off);
            off += 4;
        } else {
            size = cr.readShort(off);
            off += 2;
        }
        for (int i = 0; i < size; ++i) {
            StackMapFrame frame = new StackMapFrame();
            off = frame.read(cr, off, buf, codeOff, labels);
            attr.frames.add(frame);
        }
        return attr;
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        if (code != null && code.length > 65535) {
            bv.putInt(this.frames.size());
        } else {
            bv.putShort(this.frames.size());
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            ((StackMapFrame)this.frames.get(i)).write(cw, maxStack, maxLocals, bv);
        }
        return bv;
    }

    protected Label[] getLabels() {
        HashSet labels = new HashSet();
        for (int i = 0; i < this.frames.size(); ++i) {
            ((StackMapFrame)this.frames.get(i)).getLabels(labels);
        }
        return labels.toArray(new Label[labels.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StackMap[");
        for (int i = 0; i < this.frames.size(); ++i) {
            sb.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        sb.append("\n]");
        return sb.toString();
    }
}

