/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm.commons;

import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.MethodAdapter;
import com.sun.corba.ee.org.objectweb.asm.MethodVisitor;
import com.sun.corba.ee.org.objectweb.asm.Type;
import java.util.HashMap;
import java.util.Map;

public class LocalVariablesSorter
extends MethodAdapter {
    private Map locals = new HashMap();
    protected final int firstLocal;
    private int nextLocal;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        super(mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.nextLocal = (8 & access) != 0 ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            this.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int opcode, int var) {
        int size;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, size));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, 1), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(0, 0);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.remap(index));
    }

    protected int newLocal(int size) {
        int var = this.nextLocal;
        this.nextLocal += size;
        return var;
    }

    private int remap(int var, int size) {
        if (var < this.firstLocal) {
            return var;
        }
        Integer key = new Integer(size == 2 ? ~var : var);
        Integer value = (Integer)this.locals.get(key);
        if (value == null) {
            value = new Integer(this.newLocal(size));
            this.locals.put(key, value);
        }
        return value;
    }

    private int remap(int var) {
        if (var < this.firstLocal) {
            return var;
        }
        Integer key = new Integer(var);
        Integer value = (Integer)this.locals.get(key);
        if (value == null && (value = (Integer)this.locals.get(key = new Integer(~var))) == null) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value;
    }
}

