/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm.util;

import com.sun.corba.ee.org.objectweb.asm.AnnotationVisitor;
import com.sun.corba.ee.org.objectweb.asm.Attribute;
import com.sun.corba.ee.org.objectweb.asm.ClassAdapter;
import com.sun.corba.ee.org.objectweb.asm.ClassReader;
import com.sun.corba.ee.org.objectweb.asm.ClassVisitor;
import com.sun.corba.ee.org.objectweb.asm.FieldVisitor;
import com.sun.corba.ee.org.objectweb.asm.MethodVisitor;
import com.sun.corba.ee.org.objectweb.asm.Type;
import com.sun.corba.ee.org.objectweb.asm.tree.AbstractInsnNode;
import com.sun.corba.ee.org.objectweb.asm.tree.ClassNode;
import com.sun.corba.ee.org.objectweb.asm.tree.MethodNode;
import com.sun.corba.ee.org.objectweb.asm.tree.analysis.Analyzer;
import com.sun.corba.ee.org.objectweb.asm.tree.analysis.Frame;
import com.sun.corba.ee.org.objectweb.asm.tree.analysis.SimpleVerifier;
import com.sun.corba.ee.org.objectweb.asm.util.CheckMethodAdapter;
import com.sun.corba.ee.org.objectweb.asm.util.TraceMethodVisitor;
import java.io.FileInputStream;
import java.util.List;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean end;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            System.exit(-1);
        }
        ClassReader cr = args[0].endsWith(".class") ? new ClassReader(new FileInputStream(args[0])) : new ClassReader(args[0]);
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn), true);
        List methods = cn.methods;
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode method = (MethodNode)methods.get(i);
            if (method.instructions.size() <= 0) continue;
            Analyzer a = new Analyzer(new SimpleVerifier(Type.getType("L" + cn.name + ";"), Type.getType("L" + cn.superName + ";"), (cn.access & 0x200) != 0));
            try {
                a.analyze(cn.name, method);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                final Frame[] frames = a.getFrames();
                System.out.println(method.name + method.desc);
                TraceMethodVisitor mv = new TraceMethodVisitor(){

                    public void visitMaxs(int maxStack, int maxLocals) {
                        for (int i = 0; i < this.text.size(); ++i) {
                            String s;
                            String string = s = frames[i] == null ? "null" : frames[i].toString();
                            while (s.length() < maxStack + maxLocals + 1) {
                                s = s + " ";
                            }
                            System.out.print(Integer.toString(i + 100000).substring(1) + " " + s + " : " + this.text.get(i));
                        }
                        System.out.println();
                    }
                };
                for (int j = 0; j < method.instructions.size(); ++j) {
                    ((AbstractInsnNode)method.instructions.get(j)).accept(mv);
                }
                mv.visitMaxs(method.maxStack, method.maxLocals);
            }
        }
    }

    public CheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 161329);
        CheckMethodAdapter.checkInternalName(name, "class name");
        if (name.equals("java/lang/Object")) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if (signature != null) {
            // empty if block
        }
        if ((access & 0x200) != 0 && !superName.equals("java/lang/Object")) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                CheckMethodAdapter.checkInternalName(interfaces[i], "interface name at index " + i);
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.cv.visitSource(file, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.cv.visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckMethodAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 30239);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 151775);
        CheckMethodAdapter.checkIdentifier(name, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (signature != null) {
            // empty if block
        }
        if (value != null) {
            CheckMethodAdapter.checkConstant(value);
        }
        FieldVisitor av = this.cv.visitField(access, name, desc, signature, value);
        return av;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 138751);
        CheckMethodAdapter.checkMethodIdentifier(name, "method name");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (signature != null) {
            // empty if block
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckMethodAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        return new CheckMethodAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.cv.visitAnnotation(desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) != 0 ? 1 : 0;
        int pri = (access & 2) != 0 ? 1 : 0;
        int n = pro = (access & 4) != 0 ? 1 : 0;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) != 0 ? 1 : 0;
        int n2 = abs = (access & 0x400) != 0 ? 1 : 0;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

