/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import com.sun.enterprise.admin.dottedname.ParsedDottedName;
import com.sun.enterprise.admin.util.TokenizerException;
import com.sun.enterprise.admin.util.TokenizerImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DottedName
implements Serializable {
    final String mSourceString;
    final ParsedDottedName mParsed;
    public static final String WILDCARDS = "*";
    public static final char BACKSLASH = '\\';
    public static final String SPECIALS = "(){}[];<>@$#";
    public static final String LEGAL_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_./\\*(){}[];<>@$#";
    private static final String NO_DOMAIN = "";
    private static final char DOMAIN_DELIM = ':';
    private static final char SEPARATOR = '.';
    private static final char ESCAPE_CHAR = '\\';
    private static final String ESCAPEABLE_CHARS = ".\\";

    public DottedName(String sourceString) {
        this.mSourceString = sourceString;
        try {
            this.mParsed = DottedName.parse(sourceString);
        }
        catch (TokenizerException e) {
            String msg = DottedNameStrings.getString("MalformedDottedName", sourceString);
            throw new IllegalArgumentException(msg);
        }
        this.checkWellFormed(sourceString, DottedName.toStringFromParsed(this.mParsed));
    }

    private void checkWellFormed(String sourceString, String correctValue) {
        if (!sourceString.equals(correctValue)) {
            String msg = DottedNameStrings.getString("MalformedDottedName", sourceString);
            throw new IllegalArgumentException(msg);
        }
    }

    public static String toString(DottedName dn, int numParts) {
        return DottedName.toString(dn.getDomain(), dn.getScope(), dn.getParts(), numParts);
    }

    public static String toString(String domain, String scope, List parts) {
        return DottedName.toString(domain, scope, parts, parts.size());
    }

    public static String toString(String domain, String scope, List parts, int numParts) {
        StringBuffer buf = new StringBuffer();
        if (domain.length() != 0) {
            buf.append(domain + ":");
        }
        buf.append(DottedName.escapePart(scope));
        for (int i = 0; i < numParts; ++i) {
            String unescapedPart = (String)parts.get(i);
            buf.append("." + DottedName.escapePart(unescapedPart));
        }
        return buf.toString();
    }

    public String toString() {
        return this.mSourceString;
    }

    public static String toString(String domain, String scope, List parts, boolean needsEscaping) {
        if (needsEscaping) {
            return DottedName.toString(domain, scope, parts);
        }
        StringBuffer buf = new StringBuffer();
        if (domain.length() != 0) {
            buf.append(domain + ":");
        }
        buf.append(scope);
        for (int i = 0; i < parts.size(); ++i) {
            buf.append("." + parts.get(i));
        }
        return buf.toString();
    }

    static boolean needsEscaping(String part) {
        boolean needsEscaping = false;
        int numChars = part.length();
        for (int i = 0; i < numChars; ++i) {
            char theChar = part.charAt(i);
            if (ESCAPEABLE_CHARS.indexOf(theChar) < 0) continue;
            needsEscaping = true;
            break;
        }
        return needsEscaping;
    }

    public static String escapePart(String part) {
        String result = part;
        if (DottedName.needsEscaping(part)) {
            int numChars = part.length();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < numChars; ++i) {
                char theChar = part.charAt(i);
                if (ESCAPEABLE_CHARS.indexOf(theChar) >= 0) {
                    buf.append('\\');
                }
                buf.append(theChar);
            }
            return buf.toString();
        }
        return result;
    }

    static String toStringFromParsed(ParsedDottedName pn) {
        return DottedName.toString(pn.mDomain, pn.mScope, pn.mParts, pn.mParts.size());
    }

    static ParsedDottedName parse(String sourceString) throws TokenizerException {
        TokenizerImpl tk = new TokenizerImpl(sourceString, ".", false, '\\', ESCAPEABLE_CHARS);
        String[] tokens = tk.getTokens();
        if (tokens.length == 0) {
            String msg = DottedNameStrings.getString("DottedNameMustHaveAtLeastOnePart", sourceString);
            throw new IllegalArgumentException(msg);
        }
        int domainDelimIndex = tokens[0].indexOf(58);
        String scope = null;
        String domain = NO_DOMAIN;
        if (domainDelimIndex >= 0) {
            domain = tokens[0].substring(0, domainDelimIndex);
            scope = tokens[0].substring(domainDelimIndex + 1, tokens[0].length());
        } else {
            scope = tokens[0];
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 1; i < tokens.length; ++i) {
            parts.add(tokens[i]);
        }
        ParsedDottedName parsedName = new ParsedDottedName(domain, scope, parts);
        return parsedName;
    }

    public String getDomain() {
        return this.mParsed.mDomain;
    }

    public String getScope() {
        return this.mParsed.mScope;
    }

    public List getParts() {
        return Collections.unmodifiableList(this.mParsed.mParts);
    }

    public String getPart(int i) {
        return (String)this.mParsed.mParts.get(i);
    }

    public static boolean isWildcardName(String name) {
        boolean isWild = false;
        int numWilds = WILDCARDS.length();
        for (int i = 0; i < numWilds; ++i) {
            char wildChar = WILDCARDS.charAt(i);
            if (name.indexOf(wildChar) < 0) continue;
            isWild = true;
            break;
        }
        return isWild;
    }

    public boolean isWildcardName() {
        return DottedName.isWildcardName(this.toString());
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 37 * hashcode + this.mSourceString.hashCode();
        hashcode = 37 * hashcode + this.mParsed.hashCode();
        return hashcode;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        equals = !(other instanceof DottedName) ? false : (other == this ? true : this.toString().equals(other.toString()));
        return equals;
    }
}

