/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.event.ConfigChangeEvent;
import com.sun.enterprise.admin.event.DependencyResolver;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.MonitoringEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.server.ApplicationServer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EventBuilder {
    public ResourceDeployEvent createResourceDeployEvent(String action, String resName) throws ConfigException {
        EventStack stack = EventContext.getEventStackFromThreadLocal();
        return this.createResourceDeployEvent(action, resName, stack.getConfigContext(), (ArrayList)stack.getConfigChangeList(), stack.getTarget());
    }

    public ResourceDeployEvent createResourceDeployEvent(String action, String resName, ConfigContext ctx, ArrayList configChanges, String target) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        String resType = EventBuilder.getResourceTypeByName(ctx, resName, target);
        ResourceDeployEvent rde = new ResourceDeployEvent(instName, resName, resType, action);
        rde.setTargetDestination(target);
        DependencyResolver dr = new DependencyResolver(ctx, target);
        rde.addDependentConfigChange(dr.resolveResources(resName, action, resType));
        rde.addConfigChange(configChanges);
        return rde;
    }

    protected static String getResourceTypeByName(ConfigContext ctx, String resName, String target) throws ConfigException {
        String type = EventBuilder.getTypeFromTarget(target);
        if (type == null) {
            type = EventBuilder.getResourceType(ctx, resName, true);
        }
        return EventBuilder.convertResourceType(type);
    }

    static String getResourceType(ConfigContext ctx, String id, boolean includePool) throws ConfigException {
        Resources root = ((Domain)ctx.getRootConfigBean()).getResources();
        ConfigBean res = root.getJdbcResourceByJndiName(id);
        if (res != null) {
            return "JdbcResource";
        }
        res = root.getMailResourceByJndiName(id);
        if (res != null) {
            return "MailResource";
        }
        res = root.getCustomResourceByJndiName(id);
        if (res != null) {
            return "CustomResource";
        }
        res = root.getExternalJndiResourceByJndiName(id);
        if (res != null) {
            return "ExternalJndiResource";
        }
        res = root.getPersistenceManagerFactoryResourceByJndiName(id);
        if (res != null) {
            return "PersistenceManagerFactoryResource";
        }
        res = root.getAdminObjectResourceByJndiName(id);
        if (res != null) {
            return "AdminObjectResource";
        }
        res = root.getConnectorResourceByJndiName(id);
        if (res != null) {
            return "ConnectorResource";
        }
        res = root.getResourceAdapterConfigByResourceAdapterName(id);
        if (res != null) {
            return "ResourceAdapterConfig";
        }
        if (includePool) {
            res = root.getJdbcConnectionPoolByName(id);
            if (res != null) {
                return "JdbcConnectionPool";
            }
            res = root.getConnectorConnectionPoolByName(id);
            if (res != null) {
                return "ConnectorConnectionPool";
            }
        }
        return null;
    }

    public void addResourceDeployEvent(String action, String target, String resName) throws ConfigException {
        EventStack stack = EventContext.getEventStackFromThreadLocal();
        ConfigContext ctx = stack.getConfigContext();
        stack.setTarget(target);
        stack.setConfigChangeList(ctx.getConfigChangeList());
        ResourceDeployEvent event = this.createResourceDeployEvent(action, resName);
        EventContext.addEvent(event);
    }

    public LogLevelChangeEvent createLogLevelChangeEvent(ConfigContext ctx, String target, String newLogLevel, String moduleName) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        LogLevelChangeEvent lde = new LogLevelChangeEvent(instName);
        lde.setTargetDestination(target);
        lde.setModuleName(moduleName);
        lde.setNewLogLevel(newLogLevel);
        return lde;
    }

    public ApplicationDeployEvent createApplicationDeployEvent(String action, String appName) throws ConfigException {
        return this.createApplicationDeployEvent(action, appName, false);
    }

    public ApplicationDeployEvent createApplicationDeployEvent(String action, String appName, boolean cascade) throws ConfigException {
        return this.createApplicationDeployEvent(action, appName, cascade, false);
    }

    public ApplicationDeployEvent createApplicationDeployEvent(String action, String appName, boolean cascade, boolean forceDeploy) throws ConfigException {
        return this.createApplicationDeployEvent(action, appName, cascade, forceDeploy, 0);
    }

    public ApplicationDeployEvent createApplicationDeployEvent(String action, String appName, boolean cascade, boolean forceDeploy, int loadUnloadAction) throws ConfigException {
        EventStack stack = EventContext.getEventStackFromThreadLocal();
        String target = stack.getTarget();
        assert (target != null);
        String instName = ApplicationServer.getServerContext().getInstanceName();
        ApplicationDeployEvent ade = new ApplicationDeployEvent(instName, appName, action, cascade, forceDeploy, loadUnloadAction);
        ade.setTargetDestination(target);
        DependencyResolver dr = new DependencyResolver(stack.getConfigContext(), target);
        ade.addDependentConfigChange(dr.resolveApplications(appName, action));
        ade.addConfigChange((ArrayList)stack.getConfigChangeList());
        return ade;
    }

    public ModuleDeployEvent createModuleDeployEvent(String action, String moduleName, String moduleType) throws ConfigException {
        return this.createModuleDeployEvent(action, moduleName, moduleType, false);
    }

    public ModuleDeployEvent createModuleDeployEvent(String action, String moduleName, String moduleType, boolean cascade) throws ConfigException {
        return this.createModuleDeployEvent(action, moduleName, moduleType, cascade, false);
    }

    public ModuleDeployEvent createModuleDeployEvent(String action, String moduleName, String moduleType, boolean cascade, boolean forceDeploy) throws ConfigException {
        EventStack stack = EventContext.getEventStackFromThreadLocal();
        String target = stack.getTarget();
        assert (target != null);
        String instName = ApplicationServer.getServerContext().getInstanceName();
        ModuleDeployEvent mde = new ModuleDeployEvent(instName, moduleName, moduleType, action, cascade);
        mde.setTargetDestination(target);
        mde.setForceDeploy(forceDeploy);
        DependencyResolver dr = new DependencyResolver(stack.getConfigContext(), target);
        mde.addDependentConfigChange(dr.resolveApplications(moduleName, action));
        mde.addConfigChange((ArrayList)stack.getConfigChangeList());
        return mde;
    }

    public ConfigChangeEvent createConfigChangeEvent(String target, ArrayList configChangeList) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        ConfigChangeEvent cce = new ConfigChangeEvent(instName, configChangeList);
        cce.setTargetDestination(target);
        return cce;
    }

    public MonitoringEvent createMonitoringEvent(ConfigContext ctx, String target, String component, String action, Object command) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        MonitoringEvent me = new MonitoringEvent(instName, component, action, command);
        me.setTargetDestination(target);
        return me;
    }

    public MonitoringLevelChangeEvent createMonitoringLevelChangeEvent(ConfigContext ctx, String target, String component, String monitoringLevel) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        MonitoringLevelChangeEvent mle = new MonitoringLevelChangeEvent(instName);
        mle.setTargetDestination(target);
        return mle;
    }

    protected static String convertResourceType(String type) {
        if (type == null) {
            return null;
        }
        if ((type = type.trim()).equals("custom-resource") || type.equals("CustomResource")) {
            return "custom";
        }
        if (type.equals("external-jndi-resource") || type.equals("ExternalJndiResource")) {
            return "external-jndi";
        }
        if (type.equals("jdbc-resource") || type.equals("JdbcResource")) {
            return "jdbc";
        }
        if (type.equals("mail-resource") || type.equals("MailResource")) {
            return "mail";
        }
        if (type.equals("persistence-manager-factory-resource") || type.equals("PersistenceManagerFactoryResource")) {
            return "pmf";
        }
        if (type.equals("admin-object-resource") || type.equals("AdminObjectResource")) {
            return "aor";
        }
        if (type.equals("connector-resource") || type.equals("ConnectorResource")) {
            return "cr";
        }
        if (type.equals("resource-adapter-config") || type.equals("ResourceAdapterConfig")) {
            return "rac";
        }
        if (type.equals("jdbc-connection-pool") || type.equals("JdbcConnectionPool")) {
            return "jcp";
        }
        if (type.equals("connector-connection-pool") || type.equals("ConnectorConnectionPool")) {
            return "ccp";
        }
        return type;
    }

    public BaseDeployEvent createModAppDeployEvent(String action, String name, ConfigContext ctx, ArrayList configChanges, String target) throws ConfigException {
        String instName = ApplicationServer.getServerContext().getInstanceName();
        BaseDeployEvent event = EventBuilder.getAppOrModuleEvent(instName, ctx, name, action);
        event.setTargetDestination(target);
        DependencyResolver dr = new DependencyResolver(ctx, target);
        event.addDependentConfigChange(dr.resolveApplications(name, action));
        event.addConfigChange(configChanges);
        return event;
    }

    public static BaseDeployEvent resolveModAppDeployEventType(BaseDeployEvent eventToResolve, ConfigContext ctx) throws ConfigException {
        String instName = eventToResolve.getInstanceName();
        String name = eventToResolve.getJ2EEComponentName();
        String action = eventToResolve.getAction();
        BaseDeployEvent event = EventBuilder.getAppOrModuleEvent(instName, ctx, name, action);
        event.setCascade(eventToResolve.getCascade());
        event.setEventId(eventToResolve.getEventId());
        if (eventToResolve.getDependentChangeList() != null) {
            event.addDependentConfigChange(eventToResolve.getDependentChangeList());
        }
        if (eventToResolve.getConfigChangeList() != null) {
            event.addConfigChange(eventToResolve.getConfigChangeList());
        }
        if (eventToResolve.getTargetDestination() != null) {
            event.setTargetDestination(eventToResolve.getTargetDestination());
        }
        return event;
    }

    private static BaseDeployEvent getAppOrModuleEvent(String instName, ConfigContext ctx, String name, String action) throws ConfigException {
        String type = EventBuilder.getAppOrModuleType(ctx, name);
        if (type != null) {
            if (type.equals("application")) {
                return new ApplicationDeployEvent(instName, name, action);
            }
            return new ModuleDeployEvent(instName, name, type, action);
        }
        return new BaseDeployEvent(instName, null, name, action);
    }

    private static String getAppOrModuleType(ConfigContext ctx, String name) throws ConfigException {
        ConfigBean[] beans = ((Domain)ctx.getRootConfigBean()).getApplications().getAllChildBeans();
        ConfigBean bean = null;
        if (beans != null) {
            for (int i = 0; i < beans.length; ++i) {
                if (!name.equals(beans[i].getAttributeValue("name"))) continue;
                bean = beans[i];
                break;
            }
        }
        if (bean == null) {
            return null;
        }
        String type = null;
        if (bean instanceof J2eeApplication) {
            type = "application";
        }
        if (bean instanceof ConnectorModule) {
            type = "connector";
        } else if (bean instanceof EjbModule) {
            type = "ejb";
        } else if (bean instanceof WebModule) {
            type = "web";
        } else if (bean instanceof AppclientModule) {
            type = "appclient";
        }
        return type;
    }

    static String getTypeFromTarget(String target) {
        String type = null;
        String msg = "\n NAZRUL Could not determine resource type for target " + target;
        try {
            StringTokenizer st;
            int tokens;
            if (target != null && (tokens = (st = new StringTokenizer(target, "|")).countTokens()) == 3) {
                String prefix = st.nextToken();
                String name = st.nextToken();
                type = st.nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }
}

