/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.event.EventKey;
import com.sun.enterprise.admin.event.MBeanLocator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class MBeanLocatorImpl
implements MBeanLocator {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    static final String UNSUPPORTED_TYPE = "event.event_key_type_not_supported";
    static final String MALFORMED_OBJECT_KEY = "event.event_key_is_malformed";

    public Object locate(Object objectKey) {
        ObjectName on = null;
        QueryExp e = null;
        if (objectKey instanceof EventKey) {
            EventKey eKey = (EventKey)objectKey;
            on = eKey.getObjectName();
            e = eKey.getQuery();
        } else if (objectKey instanceof ObjectName) {
            on = (ObjectName)objectKey;
        } else if (objectKey instanceof String) {
            try {
                on = new ObjectName((String)objectKey);
            }
            catch (Exception exp) {
                logger.log(Level.WARNING, MALFORMED_OBJECT_KEY, objectKey);
                return null;
            }
        } else {
            if (objectKey != null) {
                logger.log(Level.WARNING, UNSUPPORTED_TYPE, objectKey.getClass().getName());
            }
            return null;
        }
        return MBeanServerFactory.getMBeanServer().queryMBeans(on, e);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:  <object name> ");
            System.exit(3);
        }
        String name = args[0];
        System.out.println("name is " + args[0]);
        MBeanLocatorImpl m = new MBeanLocatorImpl();
        Set s = null;
        try {
            s = (Set)m.locate(new ObjectName(name));
        }
        catch (MalformedObjectNameException e) {
            System.out.println("Please enter a valid object name ");
            System.exit(1);
        }
        catch (NullPointerException e) {
            System.out.println("Please enter a non null object name ");
            System.exit(2);
        }
        System.out.println(" The number of beans matched that description " + s.size());
    }
}

