/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.jvm;

import com.sun.enterprise.admin.mbeans.jvm.JVMInformation;
import com.sun.enterprise.admin.mbeans.jvm.JVMInformationMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class JVMInformationCollector
extends StandardMBean
implements JVMInformationMBean,
MBeanRegistration {
    private static final String SERVER_NAME_KEY_IN_ON = "server";
    private MBeanServerConnection mbsc;
    private static final StringManager sm = StringManager.getManager(JVMInformationCollector.class);

    public JVMInformationCollector() throws NotCompliantMBeanException {
        super(JVMInformationMBean.class);
    }

    public String getThreadDump(String processName) {
        ObjectName on = this.processTarget(processName);
        String title = sm.getString("thread.dump.title", this.getInstanceNameFromObjectName(on));
        String td = title + "\n" + this.invokeMBean(on, "getThreadDump");
        return td;
    }

    public String getSummary(String processName) {
        ObjectName on = this.processTarget(processName);
        String title = sm.getString("summary.title", this.getInstanceNameFromObjectName(on));
        String s = title + "\n" + this.invokeMBean(on, "getSummary");
        return s;
    }

    public String getMemoryInformation(String processName) {
        ObjectName on = this.processTarget(processName);
        String title = sm.getString("memory.info.title", this.getInstanceNameFromObjectName(on));
        String mi = title + "\n" + this.invokeMBean(on, "getMemoryInformation");
        return mi;
    }

    public String getClassInformation(String processName) {
        ObjectName on = this.processTarget(processName);
        String title = sm.getString("class.info.title", this.getInstanceNameFromObjectName(on));
        String ci = title + "\n " + this.invokeMBean(on, "getClassInformation");
        return ci;
    }

    private ObjectName processTarget(String processName) throws RuntimeException {
        try {
            TargetType[] vts = new TargetType[]{TargetType.DAS, TargetType.SERVER};
            ConfigContext acc = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Target t = TargetBuilder.INSTANCE.createTarget(null, vts, processName, acc);
            String sn = t.getName();
            String cn = JVMInformation.class.getSimpleName();
            ObjectName on = JVMInformationCollector.formObjectName(sn, cn);
            if (!this.mbsc.isRegistered(on)) {
                String msg = sm.getString("server.unreachable", sn);
                throw new RuntimeException(msg);
            }
            return on;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String invokeMBean(ObjectName jvm, String method) throws RuntimeException {
        try {
            Object[] params = new Object[]{null};
            String[] sign = new String[]{"java.lang.String"};
            Object ret = this.mbsc.invoke(jvm, method, params, sign);
            return (String)ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postRegister(Boolean registrationDone) {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbsc = server;
        String sn = System.getProperty("com.sun.aas.instanceName");
        ObjectName on = JVMInformationCollector.formObjectName(sn, JVMInformationCollector.class.getSimpleName());
        return on;
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static ObjectName formObjectName(String sn, String cName) throws Exception {
        String domain = "com.sun.appserv";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", cName);
        props.put("category", "monitor");
        String snk = SERVER_NAME_KEY_IN_ON;
        props.put(SERVER_NAME_KEY_IN_ON, sn);
        return new ObjectName("com.sun.appserv", props);
    }

    private String getInstanceNameFromObjectName(ObjectName on) {
        return on.getKeyProperty(SERVER_NAME_KEY_IN_ON);
    }

    static String millis2HoursMinutesSeconds(long millis) {
        long secmin = millis / 1000L;
        long sec = secmin % 60L;
        long minhr = secmin / 60L;
        long min = minhr % 60L;
        long hr = minhr / 60L;
        String msg = sm.getString("m2hms", hr, min, sec);
        return msg;
    }

    static String millis2SecondsMillis(long millis) {
        long sec = millis / 1000L;
        long ms = millis % 1000L;
        String msg = sm.getString("m2sms", sec, ms);
        return msg;
    }

    static String formatLong(long sayBytes) {
        NumberFormat n = NumberFormat.getInstance();
        return n.format(sayBytes);
    }
}

