/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.jvm;

import com.sun.enterprise.admin.mbeans.jvm.StringBuilderNewLineAppender;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;

class ThreadMonitor {
    private final MBeanServerConnection mbsc;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final StringManager sm = StringManager.getManager(ThreadMonitor.class);

    public ThreadMonitor(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public final String getThreadDump() {
        long start = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        StringBuilderNewLineAppender td = new StringBuilderNewLineAppender(sb);
        try {
            ThreadInfo[] tinfos;
            ThreadMXBean tmx = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Threading", ThreadMXBean.class);
            String title = this.getTitle();
            td.append(title);
            long[] tids = tmx.getAllThreadIds();
            td.append(this.sm.getString("thread.no", tmx.getThreadCount()));
            td.append(this.sm.getString("daemon.threads.no", tmx.getDaemonThreadCount()));
            for (ThreadInfo ti : tinfos = tmx.getThreadInfo(tids, Integer.MAX_VALUE)) {
                td.append(this.dumpThread(ti));
            }
            sb.append(this.getDeadlockInfo(tmx));
            String string = td.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            double time = (double)end / 1000.0 - (double)start / 1000.0;
            logger.info("Time in seconds to get the jvm thread dump: " + time);
        }
    }

    private String dumpThread(ThreadInfo ti) {
        long ids = ti.getThreadId();
        String ss = ti.getThreadState().toString();
        String msg = this.sm.getString("thread.title", this.quote(ti.getThreadName()), ids, ss);
        StringBuilder sb = new StringBuilder(msg);
        if (ti.getLockName() != null) {
            msg = this.sm.getString("thread.waiting.on", ti.getLockName());
            sb.append(msg);
        }
        if (ti.isSuspended()) {
            msg = this.sm.getString("thread.suspended");
            sb.append(msg);
        }
        if (ti.isInNative()) {
            msg = this.sm.getString("thread.in.native");
            sb.append(msg);
        }
        sb.append(System.getProperty("line.separator"));
        if (ti.getLockOwnerName() != null) {
            msg = this.sm.getString("thread.owner", ti.getLockOwnerName(), ti.getLockOwnerId());
            sb.append(msg);
        }
        for (StackTraceElement ste : ti.getStackTrace()) {
            msg = this.sm.getString("thread.stack.element", ste.toString());
            sb.append(msg);
            sb.append(System.getProperty("line.separator"));
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    private String getTitle() throws Exception {
        RuntimeMXBean rt = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
        String vmname = rt.getVmName();
        String vmversion = rt.getVmVersion();
        String vmvendor = rt.getVmVendor();
        String title = this.sm.getString("td.title", vmname, vmversion, vmvendor);
        return title;
    }

    private String quote(String uq) {
        StringBuilder sb = new StringBuilder("\"");
        sb.append(uq).append("\"");
        return sb.toString();
    }

    private String getDeadlockInfo(ThreadMXBean tmx) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        long[] dts = tmx.findMonitorDeadlockedThreads();
        if (dts == null) {
            sb.append(this.sm.getString("no.deadlock"));
        } else {
            sb.append(this.sm.getString("deadlocks.found"));
            for (long dt : dts) {
                ThreadInfo ti = tmx.getThreadInfo(dt);
                sb.append(this.dumpThread(ti));
            }
        }
        return sb.toString();
    }
}

