/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.auth;

import com.sun.enterprise.admin.server.core.jmx.auth.ASLoginDriverImpl;
import com.sun.enterprise.admin.server.core.jmx.auth.LoginDriver;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;

public class ASJMXAuthenticator
implements JMXAuthenticator {
    private static final boolean _debug = false;
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager _strings = StringManager.getManager(ASLoginDriverImpl.class);
    private String realmName;
    private LoginDriver loginDriver;

    public ASJMXAuthenticator() {
    }

    public ASJMXAuthenticator(String realmName) {
        this.setRealmName(realmName);
    }

    public void setRealmName(String realm) {
        this.realmName = realm;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public LoginDriver getLoginDriver() {
        return this.loginDriver;
    }

    public void setLoginDriver(LoginDriver driver) {
        this.loginDriver = driver;
    }

    public Subject authenticate(Object credentials) {
        String[] userpass;
        if (credentials == null) {
            this.throwInvalidCredentialsException();
        }
        if (!(credentials instanceof String[])) {
            this.throwInvalidCredentialsException();
        }
        if ((userpass = (String[])credentials).length != 2) {
            this.throwInvalidCredentialsException();
        }
        Subject subject = null;
        if (this.loginDriver != null) {
            subject = this.loginDriver.login(userpass[0], userpass[1], this.realmName);
        }
        return subject;
    }

    private void throwInvalidCredentialsException() {
        throw new SecurityException(_strings.getString("admin.auth.invalid.credentials"));
    }
}

