/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.CombinedPatternMatcher;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.MalformedNameException;
import com.sun.enterprise.admin.common.Name;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.MonitoringEvent;
import com.sun.enterprise.admin.monitor.CommandMapper;
import com.sun.enterprise.admin.monitor.MonitorGetCommand;
import com.sun.enterprise.admin.monitor.MonitorListCommand;
import com.sun.enterprise.admin.monitor.MonitorSetCommand;
import com.sun.enterprise.admin.server.core.mbean.config.AdminBase;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeansNaming;
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;

public class GenericConfigurator
extends AdminBase {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_ATTR_NOT_FOUND = "mbean.config.attribute_not_found";
    private static final String MSG_GETMBEANINFO_FAILED = "mbean.config.getmbeaninfo_failed";
    private static final String MSG_GET_ATTRIBUTE = "mbean.config.get_attribute";
    private static final String MSG_GET_ATTRIBUTE_DEFAULT = "mbean.config.get_attribute_default";
    private static final String MSG_SET_ATTRIBUTE = "mbean.config.set_attribute";
    private static final String MSG_LIST_NAMES_CONTS = "mbean.config.list_names_continuations";
    private static StringManager localStrings = StringManager.getManager(GenericConfigurator.class);
    MBeanServer mServer = null;
    private static final String[] mAttrs = new String[0];
    private static final String[] mOpers = new String[]{"getGenericAttribute(String name), INFO", "getGenericAttributes(String[] attributeNames),   INFO", "setGenericAttribute(String name, Object objValue),  ACTION_INFO", "setGenericAttributes(javax.management.AttributeList al),          ACTION_INFO", "getMonitor(String[] name), INFO", "setMonitor(javax.management.AttributeList al), ACTION", "listMonitor(String name), INFO", "listGenericDottedNameContinuiations(String dottedName), INFO"};

    public AttributeList getGenericAttribute(String dottedName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException, MBeanConfigException {
        int i;
        sLogger.log(Level.FINEST, MSG_GET_ATTRIBUTE, dottedName);
        if (this.mServer == null) {
            this.mServer = MBeanServerFactory.getMBeanServer();
        }
        dottedName = dottedName.trim();
        String attrName = this.extractAttrNameFromDotted(dottedName);
        int prefixLen = dottedName.length() - attrName.length();
        String namePrefix = null;
        if (prefixLen > 0) {
            namePrefix = dottedName.substring(0, prefixLen);
        }
        ArrayList objectNames = this.getMBeanNamesFromDottedPattern(dottedName);
        AttributeList attrList = new AttributeList();
        for (i = 0; i < objectNames.size(); ++i) {
            this.addAttributeToList(attrList, (ObjectName)objectNames.get(i), attrName);
        }
        if (namePrefix != null && attrList != null) {
            for (i = 0; i < attrList.size(); ++i) {
                Attribute attr = (Attribute)attrList.get(i);
                attrList.set(i, new Attribute(namePrefix + attr.getName(), attr.getValue()));
            }
        }
        return attrList;
    }

    public AttributeList getGenericAttributeDefaultValues(String instanceName, String mbeanType, String[] attrNames) throws MBeanConfigException {
        sLogger.log(Level.FINEST, MSG_GET_ATTRIBUTE_DEFAULT, new String[]{instanceName, mbeanType});
        ConfigMBeanNamingInfo info = new ConfigMBeanNamingInfo(mbeanType, new String[]{instanceName}, false);
        ConfigMBeanBase mbean = info.constructConfigMBean();
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < attrNames.length; ++i) {
            Object defaultValue;
            try {
                defaultValue = mbean.getDefaultAttributeValue(attrNames[i]);
            }
            catch (AttributeNotFoundException e) {
                defaultValue = null;
            }
            catch (MBeanConfigException e) {
                defaultValue = null;
            }
            if (defaultValue == null) continue;
            attrList.add(new Attribute(attrNames[i], defaultValue));
        }
        return attrList;
    }

    public String[] listGenericDottedNameContinuiations(String dottedName) throws MalformedNameException {
        sLogger.log(Level.FINEST, MSG_LIST_NAMES_CONTS, dottedName);
        dottedName = dottedName.trim();
        String instanceName = this.extractInstanceNameFromDotted(dottedName);
        return ConfigMBeansNaming.findNameContinuation(instanceName, dottedName);
    }

    public AttributeList getGenericAttributes(String[] dottedNames) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException, MBeanConfigException {
        AttributeList list = new AttributeList();
        for (int i = 0; i < dottedNames.length; ++i) {
            list.addAll(this.getGenericAttribute(dottedNames[i]));
        }
        return list;
    }

    public AttributeList setGenericAttribute(String dottedName, Object value) throws MBeanConfigException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException {
        sLogger.log(Level.FINEST, MSG_SET_ATTRIBUTE, new Object[]{dottedName, value});
        if (this.mServer == null) {
            this.mServer = MBeanServerFactory.getMBeanServer();
        }
        String attrName = this.extractAttrNameFromDotted(dottedName);
        ArrayList objectNames = this.getMBeanNamesFromDottedPattern(dottedName);
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < objectNames.size(); ++i) {
            this.setMatchedAttributesToValue(attrList, (ObjectName)objectNames.get(i), attrName, value);
        }
        return attrList;
    }

    public AttributeList setGenericAttributes(AttributeList al) throws InvalidAttributeValueException, InstanceNotFoundException, InvalidAttributeValueException, MBeanConfigException, MBeanException, ReflectionException, MalformedNameException, MalformedObjectNameException, IntrospectionException {
        AttributeList list = new AttributeList();
        for (Attribute attribute : al) {
            String name = attribute.getName();
            Object value = attribute.getValue();
            try {
                list.addAll(this.setGenericAttribute(name, value));
            }
            catch (AttributeNotFoundException anfe) {
                sLogger.log(Level.FINE, MSG_ATTR_NOT_FOUND, name);
            }
        }
        return list;
    }

    public AttributeList getMonitor(String dottedName) throws Exception {
        Name name = new Name(dottedName);
        String instanceName = name.getNamePart(0).toString();
        CommandMapper cm = CommandMapper.getInstance(instanceName);
        MonitorGetCommand command = cm.mapGetCommand(dottedName);
        MonitoringEvent event = new MonitoringEvent(instanceName, dottedName, "get_monitoring", command);
        AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
        if (!result.getResultCode().equals("success")) {
            this.handleMonitoringError(result, instanceName, dottedName);
        }
        return (AttributeList)result.getAttribute(event.getEffectiveDestination(), "monitor.result");
    }

    public AttributeList getMonitor(String[] dottedNames) throws Exception {
        AttributeList list = new AttributeList();
        for (int i = 0; i < dottedNames.length; ++i) {
            list.addAll(this.getMonitor(dottedNames[i]));
        }
        return list;
    }

    public String[] listMonitor(String dottedName) throws Exception {
        Name name = new Name(dottedName);
        String instanceName = name.getNamePart(0).toString();
        CommandMapper cm = CommandMapper.getInstance(instanceName);
        MonitorListCommand command = cm.mapListCommand(dottedName);
        MonitoringEvent event = new MonitoringEvent(instanceName, dottedName, "list_monitorable", command);
        AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
        if (!result.getResultCode().equals("success")) {
            this.handleMonitoringError(result, instanceName, dottedName);
        }
        return (String[])result.getAttribute(event.getEffectiveDestination(), "monitor.result");
    }

    public AttributeList setMonitor(AttributeList al) throws Exception {
        AttributeList list = new AttributeList();
        for (Attribute attribute : al) {
            String name = attribute.getName();
            Object value = attribute.getValue();
            try {
                list.addAll(this.setMonitor(name, value));
            }
            catch (AttributeNotFoundException anfe) {
                sLogger.log(Level.FINE, MSG_ATTR_NOT_FOUND, name);
            }
        }
        return list;
    }

    public AttributeList setMonitor(String dottedName, Object value) throws Exception {
        Name name = new Name(dottedName);
        String instanceName = name.getNamePart(0).toString();
        CommandMapper cm = CommandMapper.getInstance(instanceName);
        MonitorSetCommand command = cm.mapSetCommand(dottedName, value);
        MonitoringEvent event = new MonitoringEvent(instanceName, dottedName, "set_monitoring", command);
        AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
        if (!result.getResultCode().equals("success")) {
            this.handleMonitoringError(result, instanceName, dottedName);
        }
        AttributeList resultList = null;
        AttributeList tmp = (AttributeList)result.getAttribute(event.getEffectiveDestination(), "monitor.result");
        for (Attribute attribute : tmp) {
            resultList = (AttributeList)attribute.getValue();
        }
        return resultList;
    }

    private int setMatchedAttributesToValue(AttributeList attrList, ObjectName objName, String attrPattern, Object value) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, MalformedNameException, IntrospectionException {
        ArrayList attrNames = this.getAttrNames(objName, attrPattern);
        if (attrNames.size() == 0) {
            String msg = localStrings.getString("admin.server.core.mbean.config.no_attributes_matched_to_pattern", attrPattern);
            throw new AttributeNotFoundException(msg);
        }
        for (int i = 0; i < attrNames.size(); ++i) {
            String name = (String)attrNames.get(i);
            Object obj = this.convertValueToAttributeType(objName, name, value);
            this.mServer.setAttribute(objName, new Attribute(name, obj));
            attrList.add(new Attribute(name, obj));
        }
        return attrNames.size();
    }

    private void addAttributeToList(AttributeList attrList, ObjectName objName, String attrPattern) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, MalformedNameException, IntrospectionException {
        AttributeList list = null;
        if (attrPattern.equals("*")) {
            list = this.mServer.getAttributes(objName, new String[]{""});
            if (list != null) {
                attrList.addAll(list);
            }
        } else if (attrPattern.equals("property.*")) {
            list = this.mServer.getAttributes(objName, new String[]{"property."});
            if (list != null) {
                attrList.addAll(list);
            }
        } else {
            Object attValue = this.mServer.getAttribute(objName, attrPattern);
            attrList.add(new Attribute(attrPattern, attValue));
        }
    }

    private void handleMonitoringError(AdminEventResult result, String instance, String compName) throws AttributeNotFoundException, InstanceNotFoundException, ServiceNotFoundException {
        String resultCode = result.getResultCode();
        if ("transmission_error".equals(resultCode)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.failed_to_connect_instance", instance);
            throw new ServiceNotFoundException(msg);
        }
        if ("mbean_not_found".equals(resultCode)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.unmatched_mbean", compName);
            throw new InstanceNotFoundException(msg);
        }
        if ("mbean_attr_not_found".equals(resultCode)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.unmatched_attribute", compName);
            throw new AttributeNotFoundException(msg);
        }
        if (!"success".equals(resultCode)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.other_monitoring_error", resultCode);
            throw new JMRuntimeException(msg);
        }
    }

    private ArrayList getAttrNames(ObjectName objName, String attrPattern) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<String> list = new ArrayList<String>();
        if (attrPattern == null) {
            return list;
        }
        if (attrPattern.indexOf(42) >= 0 || attrPattern.indexOf(63) >= 0) {
            MBeanAttributeInfo[] ai;
            MBeanInfo mi = this.mServer.getMBeanInfo(objName);
            if (mi != null && (ai = mi.getAttributes()) != null) {
                for (int i = 0; i < ai.length; ++i) {
                    String name = ai[i].getName();
                    try {
                        if (!new CombinedPatternMatcher(attrPattern, name).matches()) continue;
                        list.add(ai[i].getName());
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        } else {
            list.add(attrPattern);
        }
        return list;
    }

    private String getAttrType(ObjectName objName, String attrName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getAttrType(attrName, this.mServer.getMBeanInfo(objName));
    }

    private String getAttrType(String attrName, MBeanInfo mi) {
        if (attrName == null && mi == null) {
            return null;
        }
        MBeanAttributeInfo[] ai = mi.getAttributes();
        if (ai != null) {
            for (int i = 0; i < ai.length; ++i) {
                String name = ai[i].getName();
                if (!attrName.equals(ai[i].getName())) continue;
                return ai[i].getType();
            }
        }
        return null;
    }

    private ArrayList getTargetObjectNames(ObjectName objectNamePattern) throws MalformedObjectNameException {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        if (objectNamePattern == null) {
            return list;
        }
        Set<ObjectInstance> mNames = this.mServer.queryMBeans(objectNamePattern, null);
        Iterator<ObjectInstance> it = mNames.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        if (list.size() == 0) {
            list.add(objectNamePattern);
        }
        return list;
    }

    String extractAttrNameFromDotted(String dottedStringName) throws MalformedNameException {
        int idx2;
        int idx = dottedStringName.lastIndexOf(46);
        if (idx <= 0 || idx == dottedStringName.length() - 1) {
            String msg = localStrings.getString("admin.server.core.mbean.config.cannot_extract_attribute_name_from_dotted_notation", dottedStringName);
            throw new MalformedNameException(msg);
        }
        if (dottedStringName.substring(0, idx + 1).endsWith("property.") && dottedStringName.charAt(idx2 = idx - "property.".length()) == '.' && (idx = idx2) < 1) {
            String msg = localStrings.getString("admin.server.core.mbean.config.cannot_extract_attribute_name_from_dotted_notation", dottedStringName);
            throw new MalformedNameException(msg);
        }
        return dottedStringName.substring(idx + 1);
    }

    String extractInstanceNameFromDotted(String dottedName) throws MalformedNameException {
        Name name = new Name(dottedName);
        return name.getNamePart(0).toString();
    }

    ArrayList getMBeanNamesFromDottedPattern(String dottedStringName) throws MBeanConfigException, MalformedNameException, MalformedObjectNameException {
        String attrName = this.extractAttrNameFromDotted(dottedStringName);
        int idx = dottedStringName.length() - attrName.length() - 1;
        if (idx < 1) {
            String msg = localStrings.getString("admin.server.core.mbean.config.genericconfigurator_cannot_extract_attribute_name_from_dotted_notation", dottedStringName);
            throw new MalformedNameException(msg);
        }
        ConfigMBeanNamingInfo info = new ConfigMBeanNamingInfo(dottedStringName.substring(0, idx));
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        list.add(info.getObjectName());
        return list;
    }

    private Object convertValueToAttributeType(ObjectName objName, String attrName, Object value) {
        try {
            if (value instanceof String) {
                String type = this.getAttrType(objName, attrName);
                return MBeanEasyConfig.convertStringValueToProperType((String)value, type);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return value;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return new MBeanEasyConfig(this.getClass(), mAttrs, mOpers, null).getMBeanInfo();
        }
        catch (Throwable e) {
            sLogger.log(Level.FINE, MSG_GETMBEANINFO_FAILED, e);
            return null;
        }
    }

    protected Class getImplementingClass() {
        return this.getClass();
    }

    protected Object getImplementingMBean() {
        return this;
    }
}

