/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.snmp;

import com.sun.enterprise.admin.common.domains.registry.DomainEntry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class ExtractDomainRoots {
    public String[] getAllDomainRoots() {
        Vector<String> vt = new Vector<String>();
        String[] domains = null;
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            Iterator it = domainRegistry.iterator();
            while (it.hasNext()) {
                DomainEntry entry = (DomainEntry)it.next();
                vt.addElement(entry.getRoot().getPath());
            }
            domains = new String[vt.size()];
            domains = vt.toArray(domains);
        }
        catch (DomainRegistryException e) {
            System.err.println("ExtractDomainRoots: Exception caught, while parsing the domain registry");
            e.printStackTrace();
        }
        return domains;
    }

    public void writeDomainInfo(String[] domains) {
        String fileName = new String("/tmp/appserv_domainInfo.txt");
        try {
            File domainFile = new File(fileName);
            FileWriter domainFileWriter = new FileWriter(domainFile);
            for (int i = 0; i < domains.length; ++i) {
                domainFileWriter.write(domains[i]);
                domainFileWriter.write("\n");
                System.out.println(domains[i]);
            }
            domainFileWriter.flush();
            domainFileWriter.close();
        }
        catch (IOException e) {
            System.out.println("ExtractDomainRoots: IOException caught while writing domain information to file");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("ExtractDomainRoots: Exception caught while writing domain information to file");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ExtractDomainRoots droot = new ExtractDomainRoots();
        String[] dInfo = droot.getAllDomainRoots();
        droot.writeDomainInfo(dInfo);
    }
}

