/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class MdbContainerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            if (name != null && value != null) {
                result = this.validateAttribute(name, (String)value);
            }
            return result;
        }
        return result;
    }

    public Result validateAttribute(String name, String value) {
        Result result = new Result();
        boolean isFailed = false;
        result.passed("Passed **");
        if (name.equals("steady-pool-size")) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals("max-pool-size")) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool size cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max Pool Size : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals("pool-resize-quantity")) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool Resize Qty cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize  Qty : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals("idle-timeout-in-seconds")) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Idle Timeout in Seconds cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Idle Timeout in Seconds : invalid number"));
                isFailed = true;
            }
        }
        if (isFailed) {
            result.setStatus(1);
        }
        return result;
    }
}

