/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingSupport {
    private ClassLoader classLoader;
    private String scriptName = null;
    private ScriptEngineManager scriptEngineManager;
    private InputStream scriptStream = null;
    private Logger logger;
    private boolean isDetailed;

    public ScriptingSupport(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public ScriptingSupport(ClassLoader classLoader, Logger logger) {
        this.classLoader = classLoader;
        this.scriptEngineManager = this.createScriptEngineManager(classLoader);
        this.logger = logger;
        this.isDetailed = logger != null && logger.isLoggable(Level.FINE);
    }

    public boolean startScript(String scriptPrefix, String scriptType, Collection<String> args) {
        if (this.scriptEngineManager == null) {
            return false;
        }
        List<ScriptEngineFactory> candidateEngineFactories = this.scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory candidateEngineFactory : candidateEngineFactories) {
            String candidateResourceName;
            InputStream is;
            List<String> candidateExtensions = candidateEngineFactory.getExtensions();
            if (this.isDetailed) {
                this.logger.fine("Checking script engine factory " + candidateEngineFactory.getEngineName() + " (file type(s): " + candidateExtensions.toString() + ")");
            }
            if (!candidateExtensions.contains(scriptType)) continue;
            if (this.isDetailed) {
                this.logger.fine("Script engine supports script type " + scriptType);
            }
            if ((is = this.findScript(candidateResourceName = this.computeResourceName(scriptPrefix, scriptType))) != null) {
                if (this.isDetailed) {
                    this.logger.fine("Starting script " + candidateResourceName);
                }
                this.startExecution(candidateResourceName, candidateEngineFactory.getScriptEngine(), is, args);
                return true;
            }
            if (this.isDetailed) {
                this.logger.fine("Could not find requested script " + candidateResourceName);
            }
            return false;
        }
        if (this.isDetailed) {
            this.logger.fine("No available scripting engine supports script type " + scriptType);
        }
        return false;
    }

    public boolean startScript(String scriptPrefix, Collection<String> args) {
        if (this.scriptEngineManager == null) {
            return false;
        }
        List<ScriptEngineFactory> candidateEngineFactories = this.scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory candidateEngineFactory : candidateEngineFactories) {
            List<String> extensions = candidateEngineFactory.getExtensions();
            if (this.isDetailed) {
                this.logger.fine("Checking script engine factory " + candidateEngineFactory.getEngineName() + " (file type(s): " + extensions.toString() + ")");
            }
            for (String candidateScriptType : extensions) {
                String candidateResourceName = this.computeResourceName(scriptPrefix, candidateScriptType);
                InputStream is = this.findScript(candidateResourceName);
                if (is == null) continue;
                if (this.isDetailed) {
                    this.logger.fine("Starting script " + candidateResourceName + " in this script engine");
                }
                this.startExecution(candidateResourceName, candidateEngineFactory.getScriptEngine(), is, args);
                return true;
            }
            if (!this.isDetailed) continue;
            this.logger.fine("No script found that this engine could run");
        }
        if (this.isDetailed) {
            if (candidateEngineFactories.size() == 0) {
                this.logger.fine("No script engine factories were found; no scripting support is available");
            } else {
                this.logger.fine("No script found that is runnable by any available script engine");
            }
        }
        return false;
    }

    private String computeResourceName(String scriptPrefix, String scriptType) {
        String resourcePrefix = scriptPrefix.replace('.', '/');
        String candidateScript = resourcePrefix + "." + scriptType;
        return candidateScript;
    }

    private InputStream findScript(String candidateScript) {
        InputStream result = null;
        if (this.isDetailed) {
            this.logger.fine("Looking for script " + candidateScript);
        }
        if ((result = this.classLoader.getResourceAsStream(candidateScript)) != null) {
            if (this.isDetailed) {
                this.logger.fine("Found matching script " + candidateScript);
            }
        } else if (this.isDetailed) {
            this.logger.fine("Script " + candidateScript + " not found");
        }
        return result;
    }

    private void startExecution(String resourceName, final ScriptEngine scriptEngine, InputStream scriptStream, Collection<String> args) {
        this.scriptName = resourceName;
        this.scriptStream = scriptStream;
        final InputStreamReader isr = new InputStreamReader(scriptStream);
        Bindings bindings = scriptEngine.createBindings();
        bindings.put("arguments:java.util.Collection", args);
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(bindings, 200);
        context.setBindings(bindings, 100);
        scriptEngine.setContext(context);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    scriptEngine.eval(isr);
                }
                catch (Throwable thr) {
                    throw new RuntimeException(thr);
                }
            }
        });
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void close() throws IOException {
        if (this.scriptStream != null) {
            this.scriptStream.close();
            this.scriptStream = null;
        }
    }

    private ScriptEngineManager createScriptEngineManager(ClassLoader classLoader) {
        ScriptEngineManager result;
        block2: {
            result = null;
            try {
                result = new ScriptEngineManager(classLoader);
            }
            catch (Throwable t) {
                if (!this.isDetailed) break block2;
                this.logger.fine("Could not locate script engine manager; assuming not present");
            }
        }
        return result;
    }

    private class SimpleScriptContext
    implements ScriptContext {
        private static final String SIMPLE_SCRIPT_CONTEXT_TYPE_NAME = "javax.script.SimpleScriptContext";
        private static final String SET_BINDINGS_METHOD_NAME = "setBindings";
        private Object simpleScriptContext;

        public SimpleScriptContext() {
            try {
                Class<?> sscClass = Class.forName(SIMPLE_SCRIPT_CONTEXT_TYPE_NAME);
                Constructor<?> c = sscClass.getConstructor(new Class[0]);
                this.simpleScriptContext = c.newInstance(new Object[0]);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        public Object getObject() {
            return this.simpleScriptContext;
        }

        public void setBindings(Bindings bindings, int scope) {
            try {
                Method setBindingsMethod = this.simpleScriptContext.getClass().getMethod(SET_BINDINGS_METHOD_NAME, Class.forName("javax.script.Bindings"), Integer.TYPE);
                setBindingsMethod.invoke(this.simpleScriptContext, bindings.getObject(), scope);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }
    }

    private static interface ScriptContext {
        public static final int GLOBAL_SCOPE = 200;
        public static final int ENGINE_SCOPE = 100;

        public void setBindings(Bindings var1, int var2);

        public Object getObject();
    }

    private class Bindings {
        private static final String PUT_METHOD_NAME = "put";
        private Object bindings;

        public Bindings(Object bindings) {
            this.bindings = bindings;
        }

        public Object put(String name, Object value) {
            try {
                Method putMethod = this.bindings.getClass().getMethod(PUT_METHOD_NAME, String.class, Object.class);
                return putMethod.invoke(this.bindings, name, value);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        protected Object getObject() {
            return this.bindings;
        }
    }

    private class ScriptEngine {
        private static final String EVAL_METHOD_NAME = "eval";
        private static final String CREATE_BINDINGS_METHOD_NAME = "createBindings";
        private static final String SET_CONTEXT_METHOD_NAME = "setContext";
        public Object scriptEngine;

        public ScriptEngine(Object o) {
            this.scriptEngine = o;
        }

        public void eval(InputStreamReader reader) {
            try {
                Method evalMethod = this.scriptEngine.getClass().getMethod(EVAL_METHOD_NAME, Reader.class);
                evalMethod.invoke(this.scriptEngine, reader);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        public Bindings createBindings() {
            try {
                Method createBindingsMethod = this.scriptEngine.getClass().getMethod(CREATE_BINDINGS_METHOD_NAME, new Class[0]);
                Object bindings = createBindingsMethod.invoke(this.scriptEngine, new Object[0]);
                return new Bindings(bindings);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        public void setContext(ScriptContext ctx) {
            try {
                Method setContextMethod = this.scriptEngine.getClass().getMethod(SET_CONTEXT_METHOD_NAME, Class.forName("javax.script.ScriptContext"));
                setContextMethod.invoke(this.scriptEngine, ctx.getObject());
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptEngineFactoryImpl
    implements ScriptEngineFactory {
        private static final String GET_SCRIPT_ENGINE_METHOD_NAME = "getScriptEngine";
        private static final String GET_EXTENSIONS_METHOD_NAME = "getExtensions";
        private static final String GET_ENGINE_NAME_METHOD_NAME = "getEngineName";
        private Object scriptEngineFactory;

        public ScriptEngineFactoryImpl(Object o) {
            this.scriptEngineFactory = o;
        }

        @Override
        public List<String> getExtensions() {
            ArrayList<String> result = new ArrayList<String>();
            try {
                Method getExtensionsMethod = this.scriptEngineFactory.getClass().getMethod(GET_EXTENSIONS_METHOD_NAME, new Class[0]);
                Object extensions = getExtensionsMethod.invoke(this.scriptEngineFactory, new Object[0]);
                if (extensions instanceof List) {
                    List extensionsList = (List)extensions;
                    for (Object o : extensionsList) {
                        if (!(o instanceof String)) continue;
                        result.add((String)o);
                    }
                }
                return result;
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        @Override
        public ScriptEngine getScriptEngine() {
            try {
                Method getScriptEngineMethod = this.scriptEngineFactory.getClass().getMethod(GET_SCRIPT_ENGINE_METHOD_NAME, new Class[0]);
                Object o = getScriptEngineMethod.invoke(this.scriptEngineFactory, new Object[0]);
                return new ScriptEngine(o);
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }

        @Override
        public String getEngineName() {
            try {
                Method getEngineNameMethod = this.scriptEngineFactory.getClass().getMethod(GET_ENGINE_NAME_METHOD_NAME, new Class[0]);
                Object o = getEngineNameMethod.invoke(this.scriptEngineFactory, new Object[0]);
                if (o instanceof String) {
                    return (String)o;
                }
                return o.toString();
            }
            catch (Throwable thr) {
                throw new RuntimeException(thr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ScriptEngineFactory {
        public List<String> getExtensions();

        public ScriptEngine getScriptEngine();

        public String getEngineName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptEngineManager {
        private static final String SCRIPT_ENGINE_MANAGER_TYPE_NAME = "javax.script.ScriptEngineManager";
        private static final String GET_ENGINE_FACTORIES_METHOD_NAME = "getEngineFactories";
        private static final String SCRIPT_ENGINE_FACTORY_TYPE_NAME = "javax.script.ScriptEngineFactory";
        private Object scriptEngineManager;

        public ScriptEngineManager(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.scriptEngineManager = this.createScriptEngineManager(classLoader);
        }

        private Object createScriptEngineManager(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Class<?> scriptEngineManagerClass = Class.forName(SCRIPT_ENGINE_MANAGER_TYPE_NAME);
            Constructor<?> scriptEngineManagerConstructor = scriptEngineManagerClass.getConstructor(ClassLoader.class);
            Object result = scriptEngineManagerConstructor.newInstance(classLoader);
            return result;
        }

        public List<ScriptEngineFactory> getEngineFactories() {
            ArrayList<ScriptEngineFactory> result = new ArrayList<ScriptEngineFactory>();
            try {
                Class<?> scriptEngineFactoryType = Class.forName(SCRIPT_ENGINE_FACTORY_TYPE_NAME, true, this.scriptEngineManager.getClass().getClassLoader());
                Method getEngineFactoriesMethod = this.scriptEngineManager.getClass().getMethod(GET_ENGINE_FACTORIES_METHOD_NAME, new Class[0]);
                Object returnVal = getEngineFactoriesMethod.invoke(this.scriptEngineManager, new Object[0]);
                if (returnVal instanceof List) {
                    List returnList = (List)returnVal;
                    for (Object o : returnList) {
                        if (!scriptEngineFactoryType.isAssignableFrom(o.getClass())) continue;
                        result.add(new ScriptEngineFactoryImpl(o));
                    }
                }
                return result;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

