/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.RelativePathResolver;

public class PropertyResolver
extends RelativePathResolver {
    private Domain _domain = null;
    private Cluster _cluster = null;
    private Server _server = null;
    private Config _config = null;

    public PropertyResolver(ConfigContext configContext, String instanceName) throws ConfigException {
        this._domain = ServerHelper.getDomainConfigBean(configContext);
        this._config = ServerHelper.getConfigForServer(configContext, instanceName);
        this._server = ServerHelper.getServerByName(configContext, instanceName);
        if (ServerHelper.isServerClustered(configContext, this._server)) {
            this._cluster = ClusterHelper.getClusterForInstance(configContext, instanceName);
        }
    }

    private String getPropertyValue(String propName, SystemProperty[] props) {
        String propVal = null;
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(propName)) continue;
            return props[i].getValue();
        }
        return propVal;
    }

    public String getPropertyValue(String propName, boolean bIncludingEnvironmentVariables) {
        String propVal = null;
        if (this._server != null) {
            propVal = this.getPropertyValue(propName, this._server.getSystemProperty());
        }
        if (propVal == null) {
            if (this._cluster != null) {
                propVal = this.getPropertyValue(propName, this._cluster.getSystemProperty());
            }
            if (propVal == null && this._config != null && (propVal = this.getPropertyValue(propName, this._config.getSystemProperty())) == null && this._domain != null) {
                propVal = this.getPropertyValue(propName, this._domain.getSystemProperty());
            }
        }
        if (propVal == null) {
            propVal = super.getPropertyValue(propName, bIncludingEnvironmentVariables);
        }
        return propVal;
    }

    public String getPropertyValue(String propName) {
        return this.getPropertyValue(propName, true);
    }
}

