/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.work.monitor.ConnectorWorkMonitoringLevelListener;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.server.ResourceDeployerFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

public class ConnectorServiceImpl
implements ConnectorConstants {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry _registry = ConnectorRegistry.getInstance();
    private boolean debug = true;
    protected static int environment = 2;

    public static void initialize(int environ) {
        environment = environ;
    }

    public static int getEnviron() {
        return environment;
    }

    public String getDefaultPoolName(String jndiName) {
        return jndiName;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return moduleName + "#" + connectionDefName;
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        String resourceJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForResource(moduleName);
        return resourceJNDIName + "#" + connectionDefName;
    }

    public void create() throws ConnectorRuntimeException {
    }

    public void destroy() throws ConnectorRuntimeException {
    }

    public static boolean isServer() {
        return ConnectorServiceImpl.getEnviron() == 1;
    }

    public boolean checkAndLoadResource(String resname) {
        resname = ConnectorAdminServiceUtils.getOriginalResourceName(resname);
        _logger.fine("ConnectorServiceImpl :: checkAndLoadResource resolved to load " + resname);
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        DeferredResourceConfig defResConfig = resutil.getDeferredResourceConfig(resname);
        return this.loadResourcesAndItsRar(defResConfig);
    }

    public boolean checkAndLoadPoolResource(String poolName) {
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        DeferredResourceConfig defResConfig = resutil.getDeferredPoolConfig(poolName);
        return this.loadResourcesAndItsRar(defResConfig);
    }

    public boolean loadResourcesAndItsRar(DeferredResourceConfig defResConfig) {
        if (defResConfig != null) {
            try {
                this.loadDeferredResources(defResConfig.getResourceAdapterConfig());
                String rarName = defResConfig.getRarName();
                this.loadDeferredResourceAdapter(rarName);
                final ConfigBean[] resToLoad = defResConfig.getResourcesToLoad();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            ConnectorServiceImpl.this.loadDeferredResources(resToLoad);
                        }
                        catch (Exception ex) {
                            _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                            _logger.log(Level.SEVERE, "", ex);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                _logger.log(Level.SEVERE, "", ex);
                return false;
            }
            return true;
        }
        return false;
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        try {
            ManagerFactory.getSAConnectorModulesManager().loadOneSystemApp(rarName, true);
        }
        catch (Exception e) {
            ConnectorRuntimeException ce = new ConnectorRuntimeException(e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    public void loadDeferredResources(ConfigBean[] resourcesToLoad) throws Exception {
        if (resourcesToLoad == null || resourcesToLoad.length == 0) {
            return;
        }
        String resourceType = null;
        ResourceDeployer deployer = null;
        ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
        for (int i = 0; i < resourcesToLoad.length; ++i) {
            ResourceDeployerFactory factory;
            if (resourcesToLoad[i] == null || !resourceUtil.isEnabled(resourcesToLoad[i]) || (deployer = (factory = new ResourceDeployerFactory()).getResourceDeployer(resourceType = resourceUtil.getResourceType(resourcesToLoad[i]))) == null) continue;
            deployer.deployResource(resourcesToLoad[i]);
        }
    }

    public void ifSystemRarLoad(String rarName) throws ConnectorRuntimeException {
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        if (resUtil.belongToSystemRar(rarName)) {
            this.loadDeferredResourceAdapter(rarName);
        }
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        ClassLoader rarLoader;
        ActiveResourceAdapter ar = _registry.getActiveResourceAdapter(rarName);
        if (ar != null && loader != null && (rarLoader = ar.getClassLoader()) != null && !(rarLoader instanceof ConnectorClassLoader)) {
            ClassLoader parent = loader;
            while (true) {
                if (parent.equals(rarLoader)) {
                    return true;
                }
                final ClassLoader temp = parent;
                Object obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return temp.getParent();
                    }
                });
                if (obj == null) break;
                parent = (ClassLoader)obj;
            }
            return false;
        }
        return true;
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        if (rarName == null) {
            return null;
        }
        ConnectorDescriptor desc = null;
        desc = _registry.getDescriptor(rarName);
        if (desc != null) {
            return desc;
        }
        String moduleDir = null;
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        if (rarName.indexOf("#") != -1) {
            desc = this.loadConnectorDescriptorForEmbeddedRAR(rarName);
            if (desc != null) {
                return desc;
            }
        }
        if (resUtil.belongToSystemRar(rarName)) {
            ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
            moduleDir = installer.getSystemModuleLocation(rarName);
        } else {
            moduleDir = resUtil.getLocation(rarName);
        }
        if (moduleDir != null) {
            desc = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir);
        } else {
            _logger.log(Level.SEVERE, "rardeployment.no_module_deployed", rarName);
        }
        return desc;
    }

    private ConnectorDescriptor loadConnectorDescriptorForEmbeddedRAR(String rarName) throws ConnectorRuntimeException {
        try {
            String appName = rarName.substring(0, rarName.indexOf("#"));
            String actualRarName = rarName.substring(rarName.indexOf("#") + 1);
            String appDeployLocation = ResourcesUtil.createInstance().getApplicationDeployLocation(appName);
            FileArchive in = new FileArchive();
            in.open(appDeployLocation);
            ApplicationArchivist archivist = new ApplicationArchivist();
            Application application = (Application)archivist.open(in);
            Set s = application.getRarDescriptors();
            for (ConnectorDescriptor element : s) {
                String rardescname = element.getDeployName().substring(0, element.getDeployName().indexOf(".rar"));
                if (!rardescname.equals(actualRarName)) continue;
                return element;
            }
        }
        catch (SAXParseException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException("SAXParseException while trying to load connector descriptor for embedded RAR");
            crex.initCause(e);
            throw crex;
        }
        catch (IOException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException("SAXParseException while trying to load connector descriptor for embedded RAR");
            crex.initCause(e);
            throw crex;
        }
        return null;
    }

    public void switchOnMatching(String rarName, String poolName) {
        PoolManager poolMgr;
        boolean result;
        if ((rarName.equals("__ds") || rarName.equals("__cp") || rarName.equals("__xa")) && !(result = (poolMgr = Switch.getSwitch().getPoolManager()).switchOnMatching(poolName))) {
            try {
                this.getRuntime().switchOnMatchingInJndi(poolName);
            }
            catch (ConnectorRuntimeException cre) {
                // empty catch block
            }
        }
    }

    public void initializeConnectorMonitoring() {
        Switch.getSwitch().getPoolManager().initializeMonitoring();
        this.initializeWorkMgmtAndEndPointMonitoring();
    }

    private void initializeWorkMgmtAndEndPointMonitoring() {
        try {
            final ConnectorWorkMonitoringLevelListener cwmll = new ConnectorWorkMonitoringLevelListener();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerContext ctxt = ApplicationServer.getServerContext();
                    if (ctxt != null) {
                        MonitoringRegistry monitoringRegistry_ = ctxt.getMonitoringRegistry();
                        monitoringRegistry_.registerMonitoringLevelListener((MonitoringLevelListener)cwmll, MonitoredObjectType.CONNECTOR_WORKMGMT);
                    }
                    return null;
                }
            });
            _logger.log(Level.FINE, "poolmon.init_monitoring_registry");
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "poolmon.error_registering_listener", e);
        }
    }

    protected ConnectorRuntime getRuntime() {
        return ConnectorRuntime.getRuntime();
    }
}

