/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.util.RelativePathResolver;
import java.util.logging.Level;

public class DASResourcesUtil
extends ResourcesUtil {
    boolean noReferenceCheckNeeded = false;

    protected DASResourcesUtil() throws ConfigException {
    }

    protected DASResourcesUtil(ConfigContext configContext) throws ConfigException {
        super(configContext);
    }

    public static void setAdminConfigContext() throws ConfigException {
        if (!DASResourcesUtil.isDAS()) {
            String message = localStrings.getString("cannot.set.admin.context");
            throw new ConfigException(message);
        }
        DASResourcesUtil resUtil = new DASResourcesUtil(AdminService.getAdminService().getAdminContext().getAdminConfigContext());
        resUtil.noReferenceCheckNeeded = true;
        localResourcesUtil.set(resUtil);
    }

    public static void resetAdminConfigContext() {
        localResourcesUtil.set(null);
    }

    public String getLocation(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Domain domain = null;
        try {
            domain = ServerBeansFactory.getDomainBean(adminConfigCtx);
        }
        catch (ConfigException e) {
            String message = localStrings.getString("error.getting.domain");
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
            return null;
        }
        ConnectorModule connectorModule = domain.getApplications().getConnectorModuleByName(moduleName);
        if (connectorModule == null) {
            return null;
        }
        String connectorModuleLocation = connectorModule.getLocation();
        String connectorModuleLocationResolved = RelativePathResolver.resolvePath(connectorModuleLocation);
        return connectorModuleLocationResolved;
    }

    public String getApplicationDeployLocation(String appName) {
        ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Domain domain = null;
        try {
            domain = ServerBeansFactory.getDomainBean(adminConfigCtx);
        }
        catch (ConfigException e) {
            String message = localStrings.getString("error.getting.domain");
            _logger.log(Level.WARNING, message + e.getMessage());
            _logger.log(Level.FINE, message + e.getMessage(), e);
            return null;
        }
        J2eeApplication app = domain.getApplications().getJ2eeApplicationByName(appName);
        return RelativePathResolver.resolvePath(app.getLocation());
    }

    protected boolean isReferenced(String resourceName) throws ConfigException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced in DASResourcesUtil:: " + resourceName);
        }
        if (this.noReferenceCheckNeeded) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("getConnectionFromConnectorRuntime :: true");
            }
            return true;
        }
        return super.isReferenced(resourceName);
    }
}

