/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.ResultType;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.annotation.handlers.HandlerChainHandler;
import com.sun.enterprise.deployment.annotation.impl.HandlerProcessingResultImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import javax.enterprise.deploy.shared.ModuleType;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceHandler
extends AbstractHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return javax.jws.WebService.class;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        Class[] dependencies = new Class[]{Stateless.class};
        return dependencies;
    }

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebService newWS;
        WebServiceEndpoint endpoint;
        WebServiceEndpoint wep;
        BundleDescriptor bundleDesc;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> origAnnElem = annElem;
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongannotationlocation", "symbol annotation can only be specified on TYPE"), annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.FAILED);
        }
        if (((Class)annElem).isInterface()) {
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.PROCESSED);
        }
        javax.jws.WebService ann = (javax.jws.WebService)annInfo.getAnnotation();
        if (annCtx instanceof EjbContext && annElem.getAnnotation(Stateless.class) == null) {
            AnnotationProcessorException ape = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.webeppkgwrong", "Class {0} is annotated with @WebService and without @Stateless but is packaged in a JAR. If it is supposed to be a servlet endpoint, it should be packaged in a WAR; Deployment will continue assuming  this class to be just a POJO used by other classes in the JAR being deployed", new Object[]{((Class)annElem).getName()}), annInfo);
            ape.setFatal(false);
            throw ape;
        }
        if (annCtx instanceof EjbBundleContext && annElem.getAnnotation(Stateless.class) == null) {
            AnnotationProcessorException ape = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.webeppkgwrong", "Class {0} is annotated with @WebService and without @Stateless but is packaged in a JAR. If it is supposed to be a servlet endpoint, it should be packaged in a WAR; Deployment will continue assuming this class to be just a POJO used by other classes in the JAR being deployed", new Object[]{((Class)annElem).getName()}), annInfo);
            ape.setFatal(false);
            throw ape;
        }
        if (annCtx instanceof WebBundleContext && annElem.getAnnotation(Stateless.class) != null) {
            AnnotationProcessorException ape = new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.ejbeppkgwrong", "Class {0} is annotated with @WebService and @Stateless but is packaged in a WAR. If it is supposed to be an EJB endpoint, it should be packaged in a JAR; Deployment will continue assuming this  class to be just a POJO used by other classes in the WAR being deployed", new Object[]{((Class)annElem).getName()}), annInfo);
            ape.setFatal(false);
            throw ape;
        }
        if (annElem.getAnnotation(Stateless.class) != null) {
            EjbContext ctx = (EjbContext)annCtx;
            bundleDesc = ctx.getDescriptor().getEjbBundleDescriptor();
            bundleDesc.setSpecVersion("3.0");
        } else {
            bundleDesc = annCtx instanceof WebComponentContext ? ((WebComponentContext)annCtx).getDescriptor().getWebBundleDescriptor() : ((WebBundleContext)annCtx).getDescriptor();
            bundleDesc.setSpecVersion("2.5");
        }
        String portComponentName = ann.name();
        String svcNameFromImplClass = ann.serviceName();
        String implClassName = ((Class)annElem).getSimpleName();
        String implClassFullName = ((Class)annElem).getName();
        String targetNameSpace = ann.targetNamespace();
        String portNameFromImplClass = ann.portName();
        if (portNameFromImplClass == null || portNameFromImplClass.length() == 0) {
            portNameFromImplClass = portComponentName != null && portComponentName.length() != 0 ? portComponentName + "Port" : implClassName + "Port";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        String wsdlLocation = null;
        if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            wsdlLocation = ann.wsdlLocation();
        }
        boolean sibAnnotationOverriden = false;
        if (ann.endpointInterface() != null && ann.endpointInterface().length() > 0) {
            Class<?> endpointIntf;
            try {
                endpointIntf = ((Class)annElem).getClassLoader().loadClass(ann.endpointInterface());
            }
            catch (ClassNotFoundException cfne) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.classnotfound", "class {0} referenced from annotation symbol cannot be loaded"), annInfo);
            }
            annElem = endpointIntf;
            ann = annElem.getAnnotation(javax.jws.WebService.class);
            if (ann == null) {
                throw new AnnotationProcessorException("SEI " + ((javax.jws.WebService)annInfo.getAnnotation()).endpointInterface() + " referenced from the @WebService annotation on " + ((Class)annElem).getName() + " does not contain a @WebService annotation");
            }
            sibAnnotationOverriden = true;
            if (annElem.getAnnotation(BindingType.class) != null) {
                throw new AnnotationProcessorException("SEI " + ((javax.jws.WebService)annInfo.getAnnotation()).endpointInterface() + " cannot have @BindingType");
            }
        }
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        if (portComponentName == null || portComponentName.length() == 0) {
            portComponentName = implClassName;
        }
        if ((wep = wsDesc.getEndpointByName(portComponentName)) != null && wep.getServiceEndpointInterface() != null && wep.getServiceEndpointInterface().length() != 0 && !((Class)annElem).getName().equals(wep.getServiceEndpointInterface())) {
            portComponentName = implClassFullName;
        }
        if ((endpoint = wsDesc.getEndpointByName(portComponentName)) == null) {
            newWS = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? wsDesc.getWebServiceByName(svcNameFromImplClass) : wsDesc.getWebServiceByName(implClassName + "Service");
            if (newWS == null) {
                newWS = new WebService();
                if (svcNameFromImplClass != null && svcNameFromImplClass.length() != 0) {
                    newWS.setName(svcNameFromImplClass);
                } else {
                    newWS.setName(implClassName + "Service");
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            if (portComponentName != null && portComponentName.length() != 0) {
                endpoint.setEndpointName(portComponentName);
            } else {
                endpoint.setEndpointName(((Class)annElem).getName());
            }
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.2");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace != null && targetNameSpace.length() != 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                AnnotationProcessorException ape = new AnnotationProcessorException("Target Namespace in wsdl-service element does not match @WebService.targetNamespace", annInfo);
                annInfo.getProcessingContext().getErrorHandler().error(ape);
                return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.FAILED);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (endpoint.getWsdlService() != null && endpoint.getWsdlPort() != null && !endpoint.getWsdlService().getNamespaceURI().equals(endpoint.getWsdlPort().getNamespaceURI())) {
            AnnotationProcessorException ape = new AnnotationProcessorException("Target Namespace for wsdl-service and wsdl-port should be the same", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.FAILED);
        }
        if (newWS.getWsdlFileUri() == null) {
            if (wsdlLocation != null) {
                newWS.setWsdlFileUri(wsdlLocation);
            } else if (ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
                newWS.setWsdlFileUri(ann.wsdlLocation());
            }
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (endpoint.getServiceEndpointInterface() == null) {
            if (ann.endpointInterface() != null && ann.endpointInterface().length() != 0) {
                endpoint.setServiceEndpointInterface(ann.endpointInterface());
            } else {
                endpoint.setServiceEndpointInterface(((Class)annElem).getName());
            }
        }
        annElem = annInfo.getAnnotatedElement();
        if (ModuleType.WAR.equals(bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(endpoint.getEndpointName());
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptor();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else if (endpoint.getEjbLink() == null) {
            Stateless stateless = annElem.getAnnotation(Stateless.class);
            String name = stateless.name() == null || stateless.name().length() > 0 ? stateless.name() : ((Class)annElem).getSimpleName();
            EjbDescriptor ejb = ((EjbBundleDescriptor)bundleDesc).getEjbByName(name);
            endpoint.setEjbComponentImpl(ejb);
            ejb.setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            endpoint.setEjbLink(ejb.getName());
        }
        if (endpoint.getWsdlPort() == null) {
            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                if (((Class)annElem).getPackage() != null) {
                    StringTokenizer tokens = new StringTokenizer(((Class)annElem).getPackage().getName(), ".", false);
                    if (tokens.hasMoreElements()) {
                        while (tokens.hasMoreElements()) {
                            if (targetNameSpace == null || targetNameSpace.length() == 0) {
                                targetNameSpace = tokens.nextElement().toString();
                                continue;
                            }
                            targetNameSpace = tokens.nextElement().toString() + "." + targetNameSpace;
                        }
                    } else {
                        targetNameSpace = ((Class)annElem).getPackage().getName();
                    }
                } else {
                    throw new AnnotationProcessorException("JAX-WS 2.0 paragraph 3.2. The javax.jws.WebService annotation targetNamespace MUST be used for classes or interfaces in no package");
                }
                targetNameSpace = "http://" + (targetNameSpace == null ? "" : targetNameSpace + "/");
            }
            endpoint.setWsdlPort(new QName(targetNameSpace, portNameFromImplClass, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            String serviceNameSpace = endpoint.getWsdlPort().getNamespaceURI();
            String serviceName = null;
            serviceName = svcNameFromImplClass != null && svcNameFromImplClass.length() != 0 ? svcNameFromImplClass : newWS.getName();
            endpoint.setWsdlService(new QName(serviceNameSpace, serviceName, "ns1"));
        }
        if (origAnnElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, origAnnElem, origAnnElem, true);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.PROCESSED);
    }
}

