/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.archivist.PluggableArchivistsHelper;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;

public class ArchivistFactory {
    private static final PluggableArchivistsHelper defaultArchivists = ArchivistFactory.initDefaultArchivists();

    private ArchivistFactory() {
    }

    private static PluggableArchivistsHelper initDefaultArchivists() {
        PluggableArchivistsHelper result = new PluggableArchivistsHelper();
        result.registerArchivist(new ApplicationArchivist());
        result.registerArchivist(new WebArchivist());
        result.registerArchivist(new ConnectorArchivist());
        result.registerArchivist(new AppClientArchivist());
        result.registerArchivist(new EjbArchivist());
        return result;
    }

    public static PluggableArchivists getPluggableArchivists() {
        return defaultArchivists;
    }

    public static Archivist getArchivistForType(ModuleType type) {
        return defaultArchivists.getArchivistForType(type);
    }

    public static Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException {
        return defaultArchivists.getArchivistForArchive(jarFileOrDirectory);
    }

    public static Archivist getArchivistForArchive(String path) throws IOException {
        return defaultArchivists.getArchivistForArchive(path);
    }

    public static Archivist getArchivistForArchive(AbstractArchive archive) throws IOException {
        return defaultArchivists.getArchivistForArchive(archive);
    }

    public static void registerArchivist(Archivist archivist) {
        defaultArchivists.registerArchivist(archivist);
    }
}

