/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.autodeploy.AutoDeployController;
import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerFactroy;
import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoDeployControllerFactroyImpl
implements AutoDeployControllerFactroy {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static StringManager localStrings = StringManager.getManager(AutoDeployControllerFactroyImpl.class);

    public AutoDeployController createAutoDeployController(ServerContext context) throws AutoDeploymentException {
        boolean autodeployEnabled;
        ConfigContext confContext = context.getConfigContext();
        AutoDeployControllerImpl autoDeployController = null;
        Object targetConfigurationName = null;
        Object domain = null;
        String autoDeployDir = null;
        String sourcedir = null;
        String strPollingInterval = null;
        boolean verifyEnabled = false;
        boolean preJspCompilation = false;
        DasConfig dasConfig = null;
        try {
            dasConfig = ServerBeansFactory.getDasConfigBean(confContext);
        }
        catch (Exception ce) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentStartFailure");
            throw new AutoDeploymentException("Failed to start autodeploy", ce);
        }
        if (dasConfig != null && (autodeployEnabled = dasConfig.isAutodeployEnabled())) {
            String msg;
            autoDeployDir = dasConfig.getAutodeployDir();
            if (autoDeployDir != null) {
                try {
                    autoDeployDir = new PropertyResolver(confContext, context.getInstanceName()).resolve(autoDeployDir);
                    autoDeployDir = autoDeployDir.trim();
                }
                catch (ConfigException ce) {
                    autoDeployDir = null;
                }
            }
            if (autoDeployDir == null || "".equals(autoDeployDir)) {
                autoDeployDir = "autodeploy";
                sourcedir = context.getInstanceEnvironment().getAutoDeployDirPath() + File.separator + autoDeployDir;
                msg = localStrings.getString("enterprise.deployment.autodeploy.invalid_source_dir_shifting_to_default", sourcedir);
                sLogger.log(Level.WARNING, msg);
            } else {
                sourcedir = new File(autoDeployDir).isAbsolute() ? autoDeployDir : context.getInstanceEnvironment().getAutoDeployDirPath() + File.separator + autoDeployDir;
            }
            strPollingInterval = dasConfig.getAutodeployPollingIntervalInSeconds();
            verifyEnabled = dasConfig.isAutodeployVerifierEnabled();
            preJspCompilation = dasConfig.isAutodeployJspPrecompilationEnabled();
            try {
                long pollingInterval;
                try {
                    pollingInterval = Long.parseLong(strPollingInterval);
                    if (pollingInterval < 2L) {
                        msg = localStrings.getString("enterprise.deployment.autodeploy.invalid_pooling_interval_shifting_to_default", strPollingInterval, "2", "2");
                        sLogger.log(Level.WARNING, msg);
                        pollingInterval = 2L;
                    }
                }
                catch (NumberFormatException ne) {
                    String msg2 = localStrings.getString("enterprise.deployment.autodeploy.invalid_pooling_interval_shifting_to_default", strPollingInterval, "2", "2");
                    sLogger.log(Level.WARNING, msg2);
                    pollingInterval = 2L;
                }
                autoDeployController = new AutoDeployControllerImpl(sourcedir, pollingInterval);
                autoDeployController.setVerify(verifyEnabled);
                autoDeployController.setPreJspCompilation(preJspCompilation);
            }
            catch (AutoDeploymentException ae) {
                sLogger.log(Level.SEVERE, "enterprise.deployment.backend.autoDeploymentStartFailure");
                throw ae;
            }
        }
        return autoDeployController;
    }
}

