/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.ApplicationRuntimeDDFile;
import com.sun.enterprise.deployment.util.LogDomains;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class AppDD {
    private File file = null;
    private File file2 = null;
    private Set ejbModules = new HashSet();
    private Set warModules = new HashSet();
    private Set rarModules = new HashSet();
    private Set clientModules = new HashSet();
    private Application app = null;
    private Set contextRoots = null;
    private final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static StringManager localStrings = StringManager.getManager(AppDD.class);

    public AppDD(File f) throws IASDeploymentException, IOException, SAXParseException {
        this(f, false);
    }

    public AppDD(File f, boolean validateXML) throws IASDeploymentException, IOException, SAXParseException {
        if (f == null || !f.exists()) {
            String msg = localStrings.getString("enterprise.deployment.backend.bad_file_parameter", f);
            throw new IllegalArgumentException(msg);
        }
        File f2 = null;
        if (f.isDirectory()) {
            File f1 = new File(f, "META-INF");
            f = new File(f1, "application.xml");
            f2 = new File(f1, "sun-application.xml");
        }
        if (!f.exists() || f.isDirectory()) {
            String msg = localStrings.getString("enterprise.deployment.backend.no_application_xml", f.getPath());
            throw new IASDeploymentException(msg);
        }
        this.file = f;
        if (f2 != null && f2.exists() && f2.isFile()) {
            this.file2 = f2;
        }
        try {
            this.parse(validateXML);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof IASDeploymentException) {
                throw (IASDeploymentException)t;
            }
            String msg = localStrings.getString("enterprise.deployment.backend.error_parsing_application_xml", this.file.getPath(), t);
            throw new IASDeploymentException(msg, t);
        }
    }

    public Application getApplication() {
        return this.app;
    }

    public String[] getEjbModules() {
        String[] ss = new String[this.ejbModules.size()];
        return this.ejbModules.toArray(ss);
    }

    public String[] getWarModules() {
        String[] ss = new String[this.warModules.size()];
        return this.warModules.toArray(ss);
    }

    public String[] getRarModules() {
        String[] ss = new String[this.rarModules.size()];
        return this.rarModules.toArray(ss);
    }

    public String[] getClientModules() {
        String[] ss = new String[this.clientModules.size()];
        return this.clientModules.toArray(ss);
    }

    public String[] getContextRoots() {
        String[] ss = new String[this.contextRoots.size()];
        return this.contextRoots.toArray(ss);
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(boolean validateXML) throws IASDeploymentException, IOException, SAXParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            ApplicationDeploymentDescriptorFile addf = new ApplicationDeploymentDescriptorFile();
            addf.setXMLValidation(validateXML);
            if (validateXML) {
                addf.setXMLValidationLevel("parsing");
            }
            this.app = (Application)addf.read(fis);
            if (this.file2 != null) {
                FileInputStream fis2 = new FileInputStream(this.file2);
                ApplicationRuntimeDDFile arddf = new ApplicationRuntimeDDFile();
                arddf.setXMLValidation(validateXML);
                if (validateXML) {
                    arddf.setXMLValidationLevel("parsing");
                }
                this.app = (Application)arddf.read((Descriptor)this.app, fis2);
                if (fis2 != null) {
                    fis2.close();
                }
            }
            Iterator modules = this.app.getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)modules.next();
                if (md.getModuleType().equals(ModuleType.EJB)) {
                    this.ejbModules.add(md.getArchiveUri());
                    continue;
                }
                if (md.getModuleType().equals(ModuleType.WAR)) {
                    this.warModules.add(md.getArchiveUri());
                    continue;
                }
                if (md.getModuleType().equals(ModuleType.CAR)) {
                    this.clientModules.add(md.getArchiveUri());
                    continue;
                }
                if (!md.getModuleType().equals(ModuleType.RAR)) continue;
                this.rarModules.add(md.getArchiveUri());
            }
            this.setContextRoots(this.app);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void setContextRoots(Application app) throws IASDeploymentException {
        assert (app != null);
        assert (this.warModules != null);
        assert (this.contextRoots == null);
        this.contextRoots = new HashSet();
        Iterator it = this.warModules.iterator();
        while (it.hasNext()) {
            ModuleDescriptor md = app.getModuleDescriptorByUri((String)it.next());
            String cr = md.getContextRoot();
            if (this.contextRoots.add(cr)) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.duplicate_context_root", cr);
            throw new IASDeploymentException(msg);
        }
    }

    private String trim(String s) {
        int index = s.indexOf(">");
        String ret = s.substring(index + 1);
        ret = ret.substring(0, ret.indexOf("<"));
        return ret;
    }
}

