/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class ApplicationStopPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(ApplicationStopPhase.class);

    public ApplicationStopPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "appStop";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean success;
        String type = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        int loadUnloadAction = 4;
        Application app = DeploymentServiceUtils.getInstanceManager(req.getType()).getRegisteredDescriptor(req.getName());
        this.deploymentCtx.addApplication(req.getName(), app);
        if (!req.isApplication()) {
            type = DeploymentServiceUtils.getModuleTypeString(req.getType());
        } else if (app != null && app.getRarComponentCount() != 0) {
            loadUnloadAction = 6;
        }
        this.prePhaseNotify(this.getPrePhaseEvent(req));
        try {
            if (req.isConnectorModule()) {
                status.setStageStatus(2);
                return;
            }
            success = target.sendStopEvent(req.getActionCode(), req.getName(), type, req.getCascade(), req.isForced(), loadUnloadAction);
        }
        catch (DeploymentTargetException dte) {
            status.setStageStatus(0);
            if (dte.getCause() != null) {
                status.setStageException(dte.getCause());
                status.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status.setStageStatus(2);
        } else {
            status.setStageStatus(1);
            status.setStageStatusMessage("Application failed to stop");
        }
        this.postPhaseNotify(this.getPostPhaseEvent(req));
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(7, new DeploymentEventInfo(req));
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(8, new DeploymentEventInfo(req));
    }
}

