/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.pluggable.DeploymentFactory;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import java.io.File;
import java.util.Map;

public abstract class DeploymentService {
    private static DeploymentService deployService;

    public static DeploymentService getDeploymentService(ConfigContext configContext) {
        if (deployService != null) {
            return deployService;
        }
        PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        DeploymentFactory dFactory = featureFactory.getDeploymentFactory();
        deployService = dFactory.createDeploymentService(configContext);
        return deployService;
    }

    public static DeploymentService getDeploymentService() {
        ConfigContext configContext = DeploymentServiceUtils.getConfigContext();
        return DeploymentService.getDeploymentService(configContext);
    }

    public abstract DeploymentStatus deploy(DeploymentRequest var1) throws IASDeploymentException;

    public abstract DeploymentStatus deploy(File var1, File var2, String var3, String var4, DeploymentProperties var5, DeploymentCallback var6) throws IASDeploymentException;

    public abstract DeploymentStatus undeploy(DeploymentRequest var1) throws IASDeploymentException;

    public abstract DeploymentStatus undeploy(String var1, Map var2) throws IASDeploymentException;

    public abstract DeploymentStatus associate(DeploymentRequest var1) throws IASDeploymentException;

    public abstract DeploymentStatus associate(String var1, boolean var2, String var3, String var4) throws IASDeploymentException;

    public abstract DeploymentStatus associate(String var1, String var2, Map var3) throws IASDeploymentException;

    public abstract DeploymentStatus disassociate(DeploymentRequest var1) throws IASDeploymentException;

    public abstract DeploymentStatus disassociate(String var1, String var2) throws IASDeploymentException;

    public abstract DeploymentStatus disassociate(String var1, String var2, Map var3) throws IASDeploymentException;

    public abstract DeploymentStatus start(DeploymentRequest var1);

    public abstract DeploymentStatus stop(DeploymentRequest var1) throws IASDeploymentException;

    public abstract DeploymentStatus start(String var1, String var2, Map var3) throws IASDeploymentException;

    public abstract DeploymentStatus stop(String var1, String var2, Map var3) throws IASDeploymentException;

    public abstract boolean quit(String var1);

    public abstract String getModuleIDFromDD(File var1) throws Exception;
}

